% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{create_trajectory}
\alias{create_trajectory}
\title{Create a trajectory}
\usage{
create_trajectory(name = "anonymous")
}
\arguments{
\item{name}{the name of the trajectory.}
}
\value{
Returns an environment that represents the trajectory.
}
\description{
This function initialises a trajectory, which is a chain of activities followed 
by arrivals of the same type.
}
\examples{
t0 <- create_trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)

t0

t1 <- create_trajectory("trajectory with a branch") \%>\%
  seize("server", 1) \%>\%
  ## 50-50 chance for each branch
  branch(function() sample(1:2, 1), merge=c(TRUE, FALSE), 
    create_trajectory("branch1") \%>\%
      timeout(function() 1),
    create_trajectory("branch2") \%>\%
      timeout(function() rexp(1, 3)) \%>\%
      release("server", 1)
  ) \%>\%
  ## only the first branch continues here
  release("server", 1) \%>\%
  timeout(function() 2)

t1
}
\seealso{
Other methods to deal with trajectories:
\link{get_head}, \link{get_tail},
\link{get_n_activities}, \link{seize}, \link{release}, \link{timeout}, 
\link{set_attribute}, \link{branch}, \link{rollback}.
}

