% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{simrOptions}
\alias{getSimrOption}
\alias{simrOptions}
\title{Options Settings for \code{simr}}
\usage{
simrOptions(...)

getSimrOption(opt)
}
\arguments{
\item{...}{a list of names to get options, or a named list of new values to set options.}

\item{opt}{option name (character string).}
}
\value{
\code{getSimrOption} returns the current value for the option \code{x}.

\code{simrOptions} returns

\enumerate{
\item a named list of all options, if no arguments are given.
\item a named list of specified options, if a list of option names is given.
\item (invisibly) a named list of changed options with their previous values, if options are set.
}
}
\description{
Control the default behaviour of \code{simr} analyses.
}
\section{Options in \code{simr}}{


Options that can be set with this method (and their default values).

\describe{
  \item{\code{nsim}}{default number of simulations (\code{1000}).}
  \item{\code{alpha}}{default confidence level (\code{0.05}).}
  \item{\code{progress}}{use progress bars during calculations (\code{TRUE}).}
  \item{\code{binom}}{method for calculating confidence intervals (\code{"exact"}).}
  \item{\code{pbnsim}}{number of simulations for parametric bootstrap tests using \code{pbkrtest} (\code{100}).}
  \item{\code{pcmin}}{minimum number of levels for the smallest point on a \code{\link{powerCurve}} (3).}
  \item{\code{pcmax}}{maximum number of points on the default \code{\link{powerCurve}} (10).}
  \item{\code{observedPowerWarning}}{warn if an unmodified fitted mode is used (TRUE).}
}
}
\examples{

getSimrOption("nsim")
oldopts <- simrOptions(nsim=5)
getSimrOption("nsim")
simrOptions(oldopts)
getSimrOption("nsim")

}

