% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.powerSim}
\alias{print.powerSim}
\alias{print.powerCurve}
\alias{summary.powerSim}
\alias{summary.powerCurve}
\alias{confint.powerSim}
\alias{confint.powerCurve}
\title{Report simulation results}
\usage{
\method{print}{powerSim}(x, alpha = x$alpha, level = 0.95, ...)

\method{print}{powerCurve}(x, ...)

\method{summary}{powerSim}(object, alpha = object$alpha, level = 0.95,
  method = getSimrOption("binom"), ...)

\method{summary}{powerCurve}(object, alpha = object$alpha, level = 0.95,
  method = getSimrOption("binom"), ...)

\method{confint}{powerSim}(object, parm, level = 0.95,
  method = getSimrOption("binom"), alpha = object$alpha, ...)

\method{confint}{powerCurve}(object, parm, level = 0.95,
  method = getSimrOption("binom"), ...)
}
\arguments{
\item{x}{a \code{\link{powerSim}} or \code{\link{powerCurve}} object}

\item{alpha}{the significance level for the statistical test (default is that used in the call to \code{powerSim}).}

\item{level}{confidence level for power estimate}

\item{...}{additional arguments to pass to \code{\link[=binom.confint]{binom::binom.confint()}}

  \code{alpha} refers to the threshold for an effect being significant and
  thus directly determines the point estimate for the power calculation.
  \code{level} is the confidence level that is calculated for this point
  evidence and determines the width/coverage of the confidence interval for
  power.}

\item{object}{a \code{\link{powerSim}} or \code{\link{powerCurve}} object}

\item{method}{method to use for computing binomial confidence intervals (see \code{\link[=binom.confint]{binom::binom.confint()}})}

\item{parm}{currently ignored, included for S3 compatibility with \code{\link[=confint]{stats::confint}}}
}
\description{
Describe and extract power simulation results
}
\seealso{
\code{\link[=binom.confint]{binom::binom.confint}}, \code{\link{powerSim}}, \code{\link{powerCurve}}
}
