% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cut_date_by_event.R
\name{get_cut_date_by_event}
\alias{get_cut_date_by_event}
\title{Get date at which an event count is reached}
\usage{
get_cut_date_by_event(x, event)
}
\arguments{
\item{x}{A time-to-event dataset, for example, generated by \code{\link[=sim_pw_surv]{sim_pw_surv()}}.}

\item{event}{Event count at which dataset is to be cut off for analysis.}
}
\value{
A numeric value with the \code{cte} from the input dataset
at which the targeted event count is reached, or if the final event count
is never reached, the final \code{cte} at which an event occurs.
}
\description{
Get date at which an event count is reached
}
\examples{
\dontshow{if (rlang::is_installed("dplyr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

# Use default enrollment and calendar cut date
# for 50 events in the "Positive" stratum
x <- sim_pw_surv(
  n = 200,
  stratum = data.frame(
    stratum = c("Positive", "Negative"),
    p = c(.5, .5)
  ),
  fail_rate = data.frame(
    stratum = rep(c("Positive", "Negative"), 2),
    period = rep(1, 4),
    treatment = c(rep("control", 2), rep("experimental", 2)),
    duration = rep(1, 4),
    rate = log(2) / c(6, 9, 9, 12)
  ),
  dropout_rate = data.frame(
    stratum = rep(c("Positive", "Negative"), 2),
    period = rep(1, 4),
    treatment = c(rep("control", 2), rep("experimental", 2)),
    duration = rep(1, 4),
    rate = rep(.001, 4)
  )
)

d <- get_cut_date_by_event(x |> filter(stratum == "Positive"), event = 50)

y <- cut_data_by_date(x, cut_date = d)
table(y$stratum, y$event)
\dontshow{\}) # examplesIf}
}
