% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sitmo_two_seeds}
\alias{sitmo_two_seeds}
\title{Two RNG engines running side-by-side}
\usage{
sitmo_two_seeds(n, seeds)
}
\arguments{
\item{n}{An \code{unsigned int} that dictates how many realizations occur.}

\item{seeds}{A \code{vec} containing two integers greater than 0.}
}
\value{
A \code{matrix} with random sequences.
}
\description{
Shows how to create two separate RNGs and increase them together.
}
\examples{
n = 10
a = sitmo_two_seeds(n, c(1337,1338))

b = sitmo_two_seeds(n, c(1337,1337))

isTRUE(all.equal(a[,1],a[,2]))

isTRUE(all.equal(b[,1],b[,2]))

isTRUE(all.equal(a[,1],b[,1]))
}
