% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_raster_api.R
\name{.raster_crop}
\alias{.raster_crop}
\title{Raster package internal crop raster function}
\usage{
.raster_crop(
  r_obj,
  file,
  format,
  data_type,
  gdal_options,
  overwrite,
  block,
  missing_value = NA
)
}
\arguments{
\item{r_obj}{Raster package object to be written}

\item{file}{File name to save cropped raster.}

\item{format}{GDAL file format string (e.g. GTiff)}

\item{data_type}{sits internal raster data type. One of "INT1U",
"INT2U", "INT2S", "INT4U", "INT4S", "FLT4S", "FLT8S".}

\item{gdal_options}{GDAL creation option string (e.g. COMPRESS=LZW)}

\item{overwrite}{logical indicating if file can be overwritten}

\item{block}{numeric vector with names "first_col", "ncols", "first_row",
"nrows".}

\item{missing_value}{A \code{integer} with image's missing value}
}
\value{
Subset of a raster object as defined by either block
               or bbox parameters
}
\description{
Raster package internal crop raster function
}
\note{
block starts at (1, 1)
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
\keyword{internal}
