% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_file_info.R
\name{file_info_functions}
\alias{file_info_functions}
\alias{.file_info}
\alias{.file_info_nrows}
\alias{.file_info_ncols}
\alias{.file_info_path}
\alias{.file_info_paths}
\alias{.file_info_xres}
\alias{.file_info_yres}
\alias{.file_info_fids}
\alias{.file_info_timeline}
\alias{.file_info_start_date}
\alias{.file_info_end_date}
\alias{.file_info_bands}
\title{Functions to work with file info tibble}
\usage{
.file_info(cube, bands = NULL, fid = NULL, start_date = NULL, end_date = NULL)

.file_info_nrows(cube, bands = NULL)

.file_info_ncols(cube, bands = NULL)

.file_info_path(cube)

.file_info_paths(cube, bands = NULL)

.file_info_xres(cube, bands = NULL)

.file_info_yres(cube, bands = NULL)

.file_info_fids(cube)

.file_info_timeline(cube)

.file_info_start_date(cube)

.file_info_end_date(cube)

.file_info_bands(cube)
}
\arguments{
\item{cube}{Input data cube.}

\item{bands}{Bands to be filtered}

\item{fid}{Feature id (fid) to be filtered.}

\item{dates}{Dates to be filtered.}
}
\value{
Vector with requested information obtained in the file_info.

The file info for a cube with a single tile
        filtered by bands if required.

Number of rows for a given tile.
         Throws an error if rows are not equal.

Number of cols for a given tile
          Throws an error if cols are not equal

A single path to a file
         throws an error if there is more than one path.

Paths to the cube bands

The X resolution for a single tiled cube.
        Throws an error if resolution is not unique.

The Y resolution for a single tiled cube
        Throws an error if resolution is not unique

the file ids for a single tile

the timeline  for a single tile

start date for a single tile

end date for a single tile

bands present in the cube
}
\description{
Functions to work with file info tibble
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
\keyword{internal}
