% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sji.convertToLabel}
\alias{sji.convertToLabel}
\title{Replaces variable values with their associated value labels}
\usage{
sji.convertToLabel(variable)
}
\arguments{
\item{variable}{A (factor) variable.}
}
\value{
A factor variable containing with the replaced value labels.
}
\description{
This function converts (replaces) variable values (of factors) with their
associated value labels. Might be helpful for factor variables.
For instance, if you have a Gender variable with 0/1, and associated
labels are male/female, this function would convert all 0 to male and
all 1 to female in the data frame.
}
\examples{
data(efc)
print(sji.getValueLabels(efc)['c161sex'])
head(efc$c161sex)
head(sji.convertToLabel(efc$c161sex))

print(sji.getValueLabels(efc)['e42dep'])
table(efc$e42dep)
table(sji.convertToLabel(efc$e42dep))
}
\seealso{
\link{sji.convertToValue} \cr
         \link{sji.getValueLabels} \cr
         \link{sji.getVariableLabels} \cr
         \link{sji.SPSS}
}

