% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklarsomega.R
\name{baplot}
\alias{baplot}
\title{Produce a Bland-Altman plot.}
\usage{
baplot(x, y, pch = 20, col = "black", bg = "black", main = "",
  xlab = "Mean", ylab = "Difference", lwd1 = 1, lwd2 = 1, cex = 1,
  lcol = "black")
}
\arguments{
\item{x}{the first vector of outcomes.}

\item{y}{the second vector of outcomes.}

\item{pch}{the plotting character. Defaults to 20, a bullet.}

\item{col}{the foreground color. Defaults to black.}

\item{bg}{the background color. Defaults to black.}

\item{main}{a title for the plot. Defaults to no title, i.e., \code{""}.}

\item{xlab}{a title for the x axis. Defaults to \code{"Mean"}.}

\item{ylab}{a title for the y axis. Defaults to \code{"Difference"}.}

\item{lwd1}{the line width for the scatter plot. Defaults to 1.}

\item{lwd2}{the line width for the confidence band. Defaults to 1.}

\item{cex}{scaling factor for the scatter plot. Defaults to 1.}

\item{lcol}{line color for the confidence band. Defaults to black.}
}
\description{
Produce a Bland-Altman plot.
}
\details{
This function produces rather customizable Bland-Altman plots, using the \code{\link{plot}} and \code{\link{abline}} functions. The former is used to create the scatter plot. The latter is used to display the confidence band.
}
\examples{
# Reproduce the plot from Figure 4 of the package vignette.

data(cartilage)
baplot(cartilage$pre, cartilage$post, pch = 21, col = "navy", bg = "darkorange", lwd1 = 2,
       lwd2 = 2, lcol = "navy")
}
\references{
Altman, D. G. and Bland, J. M. (1983). Measurement in medicine: The analysis of method comparison studies. \emph{The Statistician}, 307--317.

Nissi, M. J., Mortazavi, S., Hughes, J., Morgan, P., and Ellermann, J. (2015). T2* relaxation time of acetabular and femoral cartilage with and without intra-articular Gd-DTPA2 in patients with femoroacetabular impingement. \emph{American Journal of Roentgenology}, \bold{204}(6), W695.
}

