% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{metadata_soils}
\alias{metadata_soils}
\title{download SLGA soils metadata}
\usage{
metadata_soils(
  product = NULL,
  attribute = NULL,
  component = NULL,
  depth = NULL,
  req_type = "desc",
  format = "native"
)
}
\arguments{
\item{product}{Character, one of the options from column 'Short_Name' in
\code{\link[slga:slga_product_info]{slga_product_info}}.}

\item{attribute}{Character, one of the options from column 'Code' in
\code{\link[slga:slga_attribute_info]{slga_attribute_info}}, where 'Type' =
'Soil'.}

\item{component}{Character, one of 'VAL', 'CLO', or 'CHI'.}

\item{depth}{Integer, a number from 1 to 6. The numbers correspond to the
 following depth ranges:
\enumerate{
 \item 0 to 5 cm.
 \item 5 to 15 cm.
 \item 15 to 30 cm.
 \item 30 to 60 cm.
 \item 60 to 100 cm.
 \item 100 to 200 cm.
 }}

\item{req_type}{Character; one of 'cap' or 'desc'. Defaults to 'desc'.}

\item{format}{Character; one of 'xml' or 'native'. Defaults to 'native'.}
}
\value{
A list or xml document object, depending on the value of 'format'.
}
\description{
Retrieves metadata from Soil and Landscape Grid of Australia soils WCS
endpoints in XML or list format.
}
\examples{
\donttest{
 cly_md <- slga::metadata_soils('NAT', 'CLY', format = 'native')
 }
}
