% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalq.R
\name{Slurm_EvalQ}
\alias{Slurm_EvalQ}
\title{Submit an expression to be evaluated to multiple jobs.}
\usage{
Slurm_EvalQ(
  expr,
  njobs = 2L,
  job_name = opts_slurmR$get_job_name(),
  tmp_path = opts_slurmR$get_tmp_path(),
  plan = "collect",
  sbatch_opt = list(),
  rscript_opt = list(),
  seeds = NULL,
  compress = TRUE,
  export = NULL,
  export_env = NULL,
  libPaths = .libPaths(),
  hooks = NULL,
  overwrite = TRUE
)
}
\arguments{
\item{expr}{An expression to be passed to Slurm.}

\item{njobs}{Integer. Number of jobs to use in the job-array. This specifies
the number of R sessions to initialize. This does not specify the number of
cores to be used.}

\item{job_name}{Character. Name of the job to be passed to \code{Slurm}.}

\item{tmp_path}{Character. Path to the directory where all the data (including
scripts) will be stored. Notice that this path must be accessible by all the
nodes in the network (See \link{opts_slurmR}).}

\item{plan}{A character scalar. (See \link{the_plan}).}

\item{sbatch_opt}{List of options to be passed to \code{sbatch}. This is usually
done by adding the flags \verb{#SBATCH} to the bash file.}

\item{rscript_opt}{List. Options to be passed to \code{Rscript}.}

\item{seeds}{Integer vector of length \code{njobs}. Seeds to be passed to each
job. When \code{NULL} (default), seeds will be picked automatically (see \link{new_rscript}).}

\item{compress}{Logical scalar (default \code{TRUE}). Passed to \link{saveRDS}. Setting
this value to \code{FALSE} can be useful when the user requires faster read/write
of R objects on disk.}

\item{export}{A named list with objects to be included in the Spawned sessions.}

\item{export_env}{An environment. Environment where the objects listed in
\code{export} are located (default \code{\link[=parent.frame]{parent.frame()}}).}

\item{libPaths}{A character vector. See \link{.libPaths}.}

\item{hooks}{A list of functions (passed to \link{new_slurm_job}).}

\item{overwrite}{Logical scalar. When \code{TRUE}, if the path specified by
\code{tmp_path/job_name} already exists, it will overwrite it, otherwise the
function returns with an error.}
}
\value{
A list of length \code{njobs}.
}
\description{
Submit an expression to be evaluated to multiple jobs.
}
