%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.t2}

\alias{plot.t2}

\title{Diagnostic Plots for Two-Sample t-statistics}

\description{
Plots of two-sample t-statistics, |t-numerator| and
t-denominator against average A, and plot of |t-numerator| against
t-denominator. For each spot on a given slide, \eqn{A = log_2
\sqrt{RG}}{A = log_2(R*G)/2}, where (R,G) denotes the red and green
fluorescence intensity pair. Points with t-statistics exceeding user
defined thresholds are highlighted. 
} 

\usage{
plot.t2(x, main.title="T plots", low=-5, high=5,...)
}

\arguments{

 \item{x}{output from the function \code{\link{stat.t2}}.}

 \item{main.title}{title for the plot.}

 \item{low}{lower threshold for t-statistic: points with t<low are
 colored in green.} 

 \item{high}{upper threshold for t-statistic: points with t>high are
   colored in red.}
 \item{\dots}{additional graphical parameters}
}

\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} 
}
\seealso{\code{\link{stat.t2}}, \code{\link{t2stat.func}},
\code{\link{plot}}, \code{\link{t.test}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
# mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Calculation of t-statistics
## cl <- c(rep(1,3), rep(2,3))
## mouse.t2 <- stat.t2(mouse.lratio, cl)

## Diagnostic plots
plot.t2(mouse.t2, "Mouse")
}    

%\keyword{microarray, ttest.}

\keyword{hplot}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
