% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Smallset_Timeline.R
\name{Smallset_Timeline}
\alias{Smallset_Timeline}
\title{Smallset Timeline}
\usage{
Smallset_Timeline(
  data,
  code,
  rowCount = 5,
  rowSelect = NULL,
  rowReturn = FALSE,
  rowNums = NULL,
  ignoreCols = NULL,
  colours = 1,
  altText = FALSE,
  printedData = FALSE,
  truncateData = NULL,
  ghostData = TRUE,
  missingDataTints = FALSE,
  font = "sans",
  sizing = sets_sizing(),
  spacing = sets_spacing(),
  labelling = sets_labelling()
)
}
\arguments{
\item{data}{Dataset that is being preprocessed.}

\item{code}{R or Python data preprocessing script. Include the filename
extension (e.g., "my_code.R" or "my_code.py"). If the script is not in the
working directory, include the file path.}

\item{rowCount}{Integer between 5-15 for number of Smallset rows.}

\item{rowSelect}{NULL, 1, or 2. If NULL, Smallset rows are randomly sampled.
If 1, Smallset rows are selected using the coverage optimisation model. If
2, Smallset rows are selected using the coverage + variety optimisation
model, which has a long run time for large datasets. Options 1 and 2 use
the Gurobi solver (v9.1.2) and require a Gurobi license. Please visit
https://www.gurobi.com to obtain a license (free academic licenses are
available).}

\item{rowReturn}{A logical. TRUE prints, to the console, the row numbers of
the rows selected for the Smallset.}

\item{rowNums}{Numeric vector indicating particular rows from the dataset to
include in the Smallset.}

\item{ignoreCols}{Character vector of column names indicating which to
exclude from the Smallset. These columns cannot be referenced in the data
preprocessing code.}

\item{colours}{Either 1, 2, or 3 for one of the pre-built colour schemes (all
are colour-blind-friendly and 3 is black/white-printer-friendly) or a list
with four hex colour codes for same, edit, add, and delete (e.g., list(same
= "#E6E3DF", edit = "#FFC500", add = "#5BA2A6", delete = "#DDC492")).}

\item{altText}{A logical. TRUE generates alternative text (alt text) for the
Smallset Timeline and prints it to the console.}

\item{printedData}{A logical. TRUE prints data values in the Smallset
snapshots.}

\item{truncateData}{Integer for the number of characters in each printed data
value. Results in characters plus an ellipsis.}

\item{ghostData}{A logical. TRUE includes empty tiles where data have been
removed.}

\item{missingDataTints}{A logical. TRUE plots a lighter colour value for a
missing data value.}

\item{font}{Any font installed in R. Default is sans.}

\item{sizing}{\link{sets_sizing} for size specifications.}

\item{spacing}{\link{sets_spacing} for space specifications.}

\item{labelling}{\link{sets_labelling} for label specifications.}
}
\value{
Returns a Smallset Timeline object, which is a plot consisting of
  `ggplot` objects assembled with `patchwork`.
}
\description{
Builds a Smallset Timeline to visualise data preprocessing
  decisions.
}
\details{
Prior to running this command, structured comments with snapshot
  instructions must be added to the preprocessing script passed to
  \code{code}. See \code{vignette("smallsets")}.
}
\examples{
set.seed(145)

Smallset_Timeline(
  data = s_data,
  code = system.file("s_data_preprocess.R", package = "smallsets")
)

}
