% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.custom}
\alias{smbinning.custom}
\title{Customized Binning}
\usage{
smbinning.custom(df, y, x, cuts)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Binary response variable (0,1). Integer (\code{int}) is required.
Name of \code{y} must not have a dot. Name "default" is not allowed.}

\item{x}{Continuous characteristic. At least 5 different values. Value \code{Inf} is not allowed. 
Name of \code{x} must not have a dot.}

\item{cuts}{Vector with the cutpoints selected by the user. It does not have a default so user must define it.}
}
\value{
The command \code{smbinning.custom} generates and object containing the necessary info and utilities for binning.
The user should save the output result so it can be used 
with \code{smbinning.plot}, \code{smbinning.sql}, and \code{smbinning.gen}.
}
\description{
It gives the user the ability to create customized cutpoints.
}
\examples{
# Population, training and testing samples (Just some basic formality for Modeling) 
pop=chileancredit # Set population
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample
rm(chileancredit)

# Remove exclusions from chileancredit dataset
LnTOBtrain=subset(train,(FlagGB==1 | FlagGB==0), select=LnTOB)

# Custom cutpoints using percentiles (20\% each)
quantile(LnTOBtrain, probs=seq(0,1,0.2), na.rm=TRUE) # See quantiles 
LnTOBPct20Breaks=as.vector(quantile(LnTOBtrain, probs=seq(0,1,0.2), na.rm=TRUE))
CutsLnTOBPct20=LnTOBPct20Breaks[2:(length(LnTOBPct20Breaks)-1)]

# Package application and results
result=smbinning.custom(df=train,y="FlagGB",x="LnTOB",cuts=CutsLnTOBPct20) # Run and save
result$ivtable # Tabulation and Information Value
}
