% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{minimizeSmoothedSequence}
\alias{minimizeSmoothedSequence}
\title{Minimize the objective function of a smoothed regression operator with respect to \eqn{betavector} using the progressive smoothing algorithm.}
\usage{
minimizeSmoothedSequence(p, obj, objgrad, muSeq = 2^seq(3, -6))
}
\arguments{
\item{p}{The dimension of the unknown parameters (regression coefficients).}

\item{obj}{The objective function of the regression operator. Note that in the case of the progressive smoothing algorithm, the objective function must be a function of both \eqn{betavector} and \eqn{mu}.}

\item{objgrad}{The gradient function of the regression operator. Note that in the case of the progressive smoothing algorithm, the gradient must be a function of both \eqn{betavector} and \eqn{mu}.}

\item{muSeq}{The sequence of Nesterov smoothing parameters. The default is \eqn{2^{-n}} for \eqn{n \in \{-3,\ldots,6\}}.}
}
\value{
The estimator \eqn{betavector} (minimizer) of the regression operator.
}
\description{
Minimize the objective function of a smoothed regression operator with respect to \eqn{betavector} using the progressive smoothing algorithm.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
betavector <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% betavector
lambda <- 1
temp <- standardLasso(X,y,lambda)
obj <- function(z,m) objFunctionSmooth(z,temp$u,temp$v,temp$w,mu=m)
objgrad <- function(z,m) objFunctionSmoothGradient(z,temp$w,temp$du,temp$dv,temp$dw,mu=m)
print(minimizeSmoothedSequence(p,obj,objgrad))

}
\references{
Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.
}
