% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_gencode.R
\docType{data}
\name{gene.curated.GRCh37}
\alias{gene.curated.GRCh37}
\title{Human gene information from the GENCODE GRCh37 version}
\format{
Data frame with columns
\describe{
\item{gene.id}{SNP ID.}
\item{chr}{chromosome.}
\item{start}{genomic start location (1-based).}
\item{end}{genomic end location.}
\item{strand}{genomic strand.}
\item{gene.name}{gene symbols mapped to the GENCODE genes.}
\item{gene.type}{gene biotypes in the GENCODE genes.}
}
}
\source{
\url{https://www.gencodegenes.org/human/release_19.html}
}
\usage{
gene.curated.GRCh37
}
\description{
Human gene information was extracted from the GENCODE release 19. This data
only contains 'KNOWN' status genes with the following gene biotypes:
protein-coding, Immunoglobulin (Ig) variable chain and T-cell receptor (TcR)
genes.
}
\examples{
head(gene.curated.GRCh37)
}
\keyword{datasets}
