% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerRelation.R
\name{newPowerRelationFromString}
\alias{newPowerRelationFromString}
\title{Create \code{PowerRelation} object from string}
\usage{
newPowerRelationFromString(
  string,
  elementNames = "[0-9a-zA-Z]",
  asWhat = identity
)
}
\arguments{
\item{string}{String representation of a power relation. Special characters such as \mjeqn{\succ}{\\succ} and
\mjeqn{\sim}{\\sim} are replaced with their ASCII equivalents \code{>} and \code{~} respectively.}

\item{elementNames}{Regular expression to match single characters in string input that should
be interpreted as a name of an element. If character does not match, it is simply ignored.}

\item{asWhat}{Elements are interpreted as string characters by default. \code{\link[base:numeric]{base::as.numeric}}
or \code{\link[base:integer]{base::as.integer}} can be passed to convert those string characters into numeric values.}
}
\value{
\code{PowerRelation} object containing vector of elements or players \verb{$elements}, an ordered list of
coalitions \verb{$rankingCoalitions} and an ordered vector of comparators \verb{$rankingComparators}
as well as an ordered list of equivalence classes \verb{$equivalenceClasses} for convenience
}
\description{
\loadmathjax
Given a pure string representation of a power relation, create a \code{PowerRelation} object.
}
\details{
Elements in this power relation are assumed to be one character long.
E.g., the coalitions \code{"{1,2,3}"} and \code{123} are equivalent, given that the \code{elementNames}
parameter tells the function to only interpret the characters \code{1}, \code{2} and \code{3} as valid element names.
}
\examples{
# Elements: 1 2 3
# 123 > 12 > 23 > 1 > (13 ~ 2)
newPowerRelationFromString("123 > 12 > 23 > 1 > 13 ~ 2", asWhat = as.numeric)

# commas, braces and spaces are ignored by default
# notice that since an empty set is not a valid name of an element,
# it is simply ignored. Since there are no valid elements at the
# end, it is interpreted as an empty set.
newPowerRelationFromString("{1,2,3} > {1,3} > {1,2 } ~ \u2205", asWhat = as.numeric)

# use unvoncentional names
pr <- newPowerRelationFromString(".,; > .;~.,~,; > .~,~;", elementNames = "[.,;]")
stopifnot(pr$elements == sort(c(".", ",", ";")))

}
\seealso{
Other newPowerRelation functions: 
\code{\link{newPowerRelation}()}
}
\concept{newPowerRelation functions}
