% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asPowerRelation.R
\name{as.PowerRelation}
\alias{as.PowerRelation}
\alias{as.PowerRelation.character}
\alias{as.PowerRelation.list}
\title{Create PowerRelation object}
\usage{
as.PowerRelation(x, ...)

\method{as.PowerRelation}{character}(x, ...)

\method{as.PowerRelation}{list}(x, ..., comparators = c(">"))
}
\arguments{
\item{x}{An object}

\item{...}{Optional additional parameters}

\item{comparators}{Vector of ">" or "~" characters}
}
\description{
Alternative ways of creating \code{\link{PowerRelation}} objects.
}
\section{Using a character string}{


The same way a power relation \eqn{\succeq}{>=} may be represented in literature (or printed by an \code{\link{PowerRelation}} object),
a simple string containing letters, numbers, \code{>} or \code{~} can be used to input a new power relation.

Every special character is ignored, with the exception of \eqn{\succeq}{\\succeq} (\code{"\\u227B"}) and \eqn{\sim}{\\sim} (\code{"\\u223C"}).

Every letter or number is assumed to be an individual element.
\code{"abc > ac"} therefore would represent two coalitions, the first one of size 3 with the elements \code{a}, \code{b}, and \code{c}.
This method does not allow for elements to be entered that are supposed to be multiple characters long.

An empty coalitions can be simply left blank (i.e., \code{"abc > ~ ac"}),
though it is often clearer if curly braces are used to indicate such (i.e., \code{"abc > {} ~ ac"}).
}

\section{Using a list}{


Create a \code{\link{PowerRelation}} object with an unnested list of coalition \link[base:c]{vectors}.

By default, a linear order is assumed on the coalitions.
I.e., if it is given \code{list(c(1,2),1,2)}, these three coalitions are put into their own equivalence class,
producing \verb{12 > 1 > 2}.

The comparators in-between can be adjusted to indicate
whether the relation between two coalitions is that of strict preference \code{>} or indifference \code{~}.
}

\examples{
# Using character strings
as.PowerRelation("abc > ab > ({} ~ c) > (a ~ b ~ ac) > bc")
# abc > ab > ({} ~ c) > (a ~ b ~ ac) > bc

# using createPowerset(), then shifting coalitions up and down using Alt+Up and Alt+Down
if(interactive()) {
  createPowerset(1:2, result = "copy")
}
as.PowerRelation("
  12
  > 1
  ~ {}
  > 2
")

# Using lists
as.PowerRelation(list(c(1,2), 2, c(), 1))
# 12 > 2 > {} > 1

as.PowerRelation(list(c(1,2), 2, c(), 1), comparators = c("~", ">", ">"))
# (12 ~ 2) > {} > 1

# the length of comparators doesn't necessarily matter.
# If comparators are missing, the existing ones are simply repeated...
as.PowerRelation(list(c(1,2), 2, c(), 1), comparators = "~")
# (12 ~ 2 ~ {} ~ 1)

as.PowerRelation(list(c(1,2), 2, c(), 1), comparators = c("~", ">"))
# (12 ~ 2) > ({} ~ 1)

# ... or the rest is cut off
as.PowerRelation(list(c(1,2), 2, c(), 1), comparators = c("~", ">", "~", "~", ">"))
# (12 ~ 2) > ({} ~ 1)
}
