% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relation.R
\name{powerRelationMatrix}
\alias{powerRelationMatrix}
\alias{as.relation.PowerRelation}
\title{Create relation matrix}
\usage{
powerRelationMatrix(
  powerRelation,
  domainNames = c("pretty", "numericPrec", "numeric")
)

\method{as.relation}{PowerRelation}(x, ...)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{domainNames}{How should the row and column names be formatted?
\itemize{
\item \code{pretty}: Coalitions such as c(1,2) are formatted as 12. To ensure that it's correctly sorted alphabetically, every name is preceded by a certain amount of the invisible Unicode character \\u200b
\item \code{numericPrec}: Coalitions such as c(1,2) are formatted as 1\{12\}, the number in front of the curly brace marking its sorted spot. While less pretty, it won't use Unicode characters.
\item \code{numeric}: Drop coalition names, only count from 1 upwards. Each number corresponds to the index in TODO \code{powerRelation$rankingCoalitions}
\item \verb{function(x)}: A custom function that is passed a number from \code{1} through \code{length(powerRelation$rankingCoalitions)}. Must return a \code{character} object.
}}

\item{x}{A \code{\link{PowerRelation}} object}

\item{...}{Further parameters (ignored)}
}
\value{
\code{\link[relations:relation]{relations::relation()}} object to the corresponding power relation.
}
\description{
For a given \code{\link{PowerRelation}} object create a \code{\link[relations:relation]{relations::relation()}} object.
}
\details{
Turn a \code{\link{PowerRelation}} object into a \code{\link[relations:relation]{relations::relation()}} object. The incidence matrix can be viewed with
\code{\link[relations:incidence]{relations::relation_incidence()}}.

The columns and rows of a \code{\link{PowerRelation}} object are ordered by TODO \code{powerRelation$rankingCoalitions}.
The \code{relations} package automatically sorts the columns and rows by their domain names, which is the reason the
parameter \code{domainNames} is included. This way we ensure that the columns and rows are sorted by
the order of the power relation.
}
\section{Cycles}{


A \code{\link{PowerRelation}} object is defined as being transitive. If a power relation includes a cycle,
meaning that the same coalition appears twice in the ranking, all coalitions within that cycle will be considered
to be indifferent from one another.

For example, given the power relation \eqn{1 \succ 2 \succ 3 \succ 1 \succ 12}{1 > 2 > 3 > 1 > 12},
the relation is somewhat equivalent to \eqn{1 \sim 2 \sim 3 \succ 12}{1 ~ 2 ~ 3 > 12}. There is no way
to check for cycles in the incidence matrix only.

Call \code{\link[=transitiveClosure]{transitiveClosure()}} to remove cycles in a \code{\link{PowerRelation}} object.
}

\examples{
pr <- as.PowerRelation("12 > 1 > 2")
relation <- powerRelationMatrix(pr)

# do relation stuff
# Incidence matrix
# 111
# 011
# 001
relations::relation_incidence(relation)

# all TRUE
stopifnot(all(
  relations::relation_is_acyclic(relation),
  relations::relation_is_antisymmetric(relation),
  relations::relation_is_linear_order(relation),
  relations::relation_is_complete(relation),
  relations::relation_is_reflexive(relation),
  relations::relation_is_transitive(relation)
))


# a power relation where coalitions {1} and {2} are indifferent
pr <- as.PowerRelation("12 > (1 ~ 2)")
relation <- powerRelationMatrix(pr)

# Incidence matrix
# 111
# 011
# 011
relations::relation_incidence(relation)

# FALSE
stopifnot(!any(
  relations::relation_is_acyclic(relation),
  relations::relation_is_antisymmetric(relation),
  relations::relation_is_linear_order(relation)
))
# TRUE
stopifnot(all(
  relations::relation_is_complete(relation),
  relations::relation_is_reflexive(relation),
  relations::relation_is_transitive(relation)
))


# a pr with cycles
pr <- suppressWarnings(as.PowerRelation("12 > 1 > 2 > 1"))
relation <- powerRelationMatrix(pr)

# Incidence matrix
# 1111
# 0111
# 0111
# 0111
relations::relation_incidence(relation)

# custom naming convention
relation <- powerRelationMatrix(
  pr,
  function(x) paste0(letters[x], ":", paste(pr$rankingCoalitions[[x]], collapse = "|"))
)

relations::relation_incidence(relation)
# Incidences:
#       a:1|2 b:1 c:2 d:1
# a:1|2     1   1   1   1
# b:1       0   1   1   1
# c:2       0   1   1   1
# d:1       0   1   1   1

}
\seealso{
\code{\link[relations:relation]{relations::as.relation()}}
}
