% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean-data.R
\name{clean_data}
\alias{clean_data}
\title{Prepare our administrative data for analysis}
\usage{
clean_data(dat = NULL, style = "long", id = NULL, prefix_dx = "dx")
}
\arguments{
\item{dat}{dataset}

\item{style}{long, the default, is one diagnosis column per row whereas wide is multiple diagnosis columns}

\item{id}{unique patient identifier variable name}

\item{prefix_dx}{the variable prefix for the diagnosis columns (defaults to "dx"), in quotes}
}
\value{
dataframe with multiple rows per patient, which has re-structured their
administrative data
}
\description{
\code{clean_data} returns a dataset which has been transformed and cleaned for subsequent functions in this
package.
}
\details{
This function takes our raw administrative data, in a number of different forms,
and prepares it in a way which allows the other functions in this package
to easily work with it. It is recommended to run this package on all data
regardless of setup.
}
\examples{
clean_data(dat = i10_wide, id = patient_id, style = "wide", prefix_dx = "dx")

}
