% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_get.r
\name{doc_get}
\alias{doc_get}
\title{Get a document from a database.}
\usage{
doc_get(cushion, dbname, docid, rev = NULL, attachments = FALSE,
  deleted = FALSE, revs = FALSE, revs_info = FALSE, conflicts = FALSE,
  deleted_conflicts = FALSE, local_seq = FALSE, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{Cushion} object. Required.}

\item{dbname}{Database name}

\item{docid}{Document ID}

\item{rev}{Revision id of the document to get. If NULL, gets current revision}

\item{attachments}{(logical) Whether to include _attachments field.}

\item{deleted}{(logical) Whether to include _deleted field.}

\item{revs}{(logical) Whether to include _revisions field.}

\item{revs_info}{(logical) Whether to include _revs_info field.}

\item{conflicts}{(logical) Whether to include _conflicts field.}

\item{deleted_conflicts}{(logical) Whether to include _deleted_conflicts field.}

\item{local_seq}{(logical) Whether to include _local_seq field.}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to one of the HTTP verbs (e.g,.
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, \code{\link[httr]{PUT}},
etc.)}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Get a document from a database.
}
\examples{
\dontrun{
(x <- Cushion$new())

if ("sofadb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="sofadb"))
}
db_create(x, dbname="sofadb")

# create a document
doc1 <- '{"name": "drink", "beer": "IPA", "score": 5}'
doc_create(x, dbname="sofadb", doc1, docid="abeer")

doc_get(x, dbname="sofadb", docid="abeer")
revs <- db_revisions(x, dbname="sofadb", docid="abeer")
doc_get(x, dbname="sofadb", docid="abeer", rev=revs[1])
doc_get(x, dbname="sofadb", docid="abeer", rev=revs[2])
doc_get(x, dbname="sofadb", docid="abeer", as='json')
doc_get(x, dbname="sofadb", docid="abeer", revs=TRUE)
doc_get(x, dbname="sofadb", docid="abeer", revs=TRUE, local_seq=TRUE)
}
}

