% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_explain.R
\name{db_explain}
\alias{db_explain}
\title{Explain API}
\usage{
db_explain(cushion, dbname, query = NULL, selector = NULL, limit = NULL,
  skip = NULL, sort = NULL, fields = NULL, use_index = NULL,
  as = "list", ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{Database name}

\item{query}{(character) instead of using the other parameters, you can
compose one R list or json blob here}

\item{selector}{(json) - JSON object describing criteria used to select
documents. More information provided in the section on selector syntax.
See the \code{query_tutorial} in this package, and the selectors docs
\url{http://docs.couchdb.org/en/2.0.0/api/database/find.html#find-selectors}}

\item{limit}{(number) - Maximum number of results returned. Default: 25
Optional}

\item{skip}{(number) - Skip the first 'n' results, where 'n' is the value
specified. Optional}

\item{sort}{(json) - JSON array following sort syntax. Optional.
See \url{http://docs.couchdb.org/en/2.0.0/api/database/find.html#find-sort}
For some reason, sort doesn't work often, not sure why.}

\item{fields}{(json) - JSON array specifying which fields of each object
should be returned. If it is omitted, the entire object is returned. More
information provided in the section on filtering fields. Optional
See \url{http://docs.couchdb.org/en/2.0.0/api/database/find.html#find-filter}}

\item{use_index}{(json) - Instruct a query to use a specific index.
Specified either as \code{<design_document>} or \code{["<design_document>", "<index_name>"]}. Optional}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Explain API
}
\examples{
\dontrun{
## create a connection
(x <- Cushion$new())

file <- system.file("examples/omdb.json", package = "sofa")
strs <- readLines(file)

## create a database
if ("omdb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="omdb"))
}
db_create(x, dbname='omdb')

## add some documents
invisible(db_bulk_create(x, "omdb", strs))

## query all in one json blob
db_explain(x, dbname = "omdb", query = '{
  "selector": {
    "_id": {
      "$gt": null
    }
  }
}')
}
}
