% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_ackley.R
\name{generate_ackley_function}
\alias{generate_ackley_function}
\title{Ackley test function generator}
\usage{
generate_ackley_function(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}] Size of parameter space.}
}
\value{
A \code{soo_function}.
}
\description{
Generator for the Ackley test function.
The Ackley function is defined as
\deqn{
  f(x)
  =
  -20 \exp
  \left(
    -0.2 \sqrt{\frac{1}{n}
               \sum_{i=1}^n \left(x_i^2\right)}
  \right) - \exp
  \left(
    \frac{1}{n}\sum_{i=1}^n \cos\left(2 \pi x_i \right)
  \right) + 20 + \exp(1)}{
f(x) = -20 * exp(-0.2 * sqrt(1/n * sum(x^2)))
       -exp(1/n * sum(cos(2 * \pi * x))) + 20 + exp(1)
}
}
\examples{
f <- generate_ackley_function(2)
plot(f, rank=TRUE)

}
\references{
D. H. Ackley. A connectionist machine for genetic hillclimbing.
Kluwer Academic Publishers, Boston, 1987
}
