% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_parameters.R
\name{random_parameters}
\alias{random_parameters}
\alias{random_parameter}
\title{Random parameter generation}
\usage{
random_parameters(n, fn)

random_parameter(fn)
}
\arguments{
\item{n}{[\code{integer(1)}]\cr Number of parameters to generate.}

\item{fn}{[\code{soo_function}] Test function.}
}
\value{
For \code{random_parameters}, a matrix containing the
parameter settings in the \emph{columns} of the
matrix. \code{random_parameter} returns a numeric vector with a
single parameter setting for the given function.
}
\description{
Generate random parameter(s) for a given function.
}
\details{
Given a test function \code{fn}, generate \code{n} random
parameter settings for that function.
}
\examples{
fn <- generate_ackley_function(10)
X <- random_parameters(100, fn)
str(X)
y <- fn(X)

}
