% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_db.R
\name{create_db}
\alias{create_db}
\title{Create a sqlite3 database}
\usage{
create_db(path, db_name = NA, table_name = "labels",
type = "reference")
}
\arguments{
\item{path}{Character. Path to the folder where the database will be created.}

\item{db_name}{Character. Name of the database to be created.}

\item{table_name}{Character. Name of the table to be created in the
database. It is mandatory to use the default table name "labels"
if the database is intended to be used in conjunction with other
functions of this package.}

\item{type}{Character indicating the type of database to create. Possible
options are: "reference" which creates a database to be used to store
recordings annotations for training purposes, and "id" which
creates a database to output the results of the automatic classification.}
}
\value{
Nothing
}
\description{
Create a sqlite3 database (if a database with the specified
name doesn't exist already) with predefined tables. Two types of
databases are possible, one to store recordings annotations and another
to store the output of the classification.
}
\examples{
\dontrun{
dir_path <- tempdir()
create_db(dir_path,
db_name = "test",
table_name = "labels",
type = "reference")
file.remove(file.path(dir_path, "test.sqlite3"))
}
}
\author{
Bruno Silva
}
