% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{generateHarmonics}
\alias{generateHarmonics}
\title{Generate harmonics}
\usage{
generateHarmonics(pitch, glottisAnchors = 0, attackLen = 50,
  nonlinBalance = 0, nonlinDep = 50, jitterDep = 0, jitterLen = 1,
  vibratoFreq = 5, vibratoDep = 0, shimmerDep = 0, creakyBreathy = 0,
  rolloff = -9, rolloffOct = -3, rolloffKHz = -3, rolloffParab = 0,
  rolloffParabHarm = 3, rolloff_perAmpl = 3, temperature = 0.025,
  pitchDriftDep = 0.5, pitchDriftFreq = 0.125, amplDriftDep = 5,
  subDriftDep = 4, rolloffDriftDep = 3, randomWalk_trendStrength = 0.5,
  shortestEpoch = 300, subFreq = 100, subDep = 0, amplAnchors = NA,
  overlap = 75, samplingRate = 16000, pitchFloor = 75,
  pitchCeiling = 3500, pitchSamplingRate = 3500, throwaway = -80)
}
\arguments{
\item{pitch}{a contour of fundamental frequency (numeric vector). NB: for
computational efficiency, provide the pitch contour at a reduced sampling
rate pitchSamplingRate, eg 3500 points/s. The pitch contour will be
upsampled before synthesis.}

\item{glottisAnchors}{anchors for specifying the proportion of a glottal
cycle with closed glottis, % (0 = no modification, 100 = closed phase as
long as open phase); numeric vector or dataframe specifying time and value}

\item{attackLen}{duration of fade-in / fade-out at each end of syllables and
noise (ms)}

\item{nonlinBalance}{hyperparameter for regulating the (approximate)
proportion of sound with different regimes of pitch effects (none /
subharmonics only / subharmonics and jitter). 0\% = no noise; 100\% = the
entire sound has jitter + subharmonics. Ignored if temperature = 0}

\item{nonlinDep}{hyperparameter for regulating the intensity of
subharmonics and jitter, 0 to 100\% (50\% = jitter and subharmonics are as
specified, <50\% weaker, >50\% stronger). Ignored if temperature = 0}

\item{jitterDep}{cycle-to-cycle random pitch variation, semitones}

\item{jitterLen}{duration of stable periods between pitch jumps, ms. Use a
low value for harsh noise, a high value for irregular vibrato or shaky
voice}

\item{vibratoFreq}{the rate of regular pitch modulation, or vibrato, Hz}

\item{vibratoDep}{the depth of vibrato, semitones}

\item{shimmerDep}{random variation in amplitude between individual glottal
cycles (0 to 100\% of original amplitude of each cycle)}

\item{creakyBreathy}{hyperparameter for a rough adjustment of voice quality
from creaky (-1) to breathy (+1)}

\item{rolloff}{basic rolloff at a constant rate of \code{rolloff} db/octave
(exponential decay). See \code{\link{getRolloff}} for more details}

\item{rolloffOct}{basic rolloff changes from lower to upper
harmonics (regardless of f0) by \code{rolloffOct} dB/oct. For
example, we can get steeper rolloff in the upper part of the spectrum}

\item{rolloffKHz}{rolloff changes linearly with f0 by
\code{rolloffKHz} dB/kHz. For ex., -6 dB/kHz gives a 6 dB
steeper basic rolloff as f0 goes up by 1000 Hz}

\item{rolloffParab}{an optional quadratic term affecting only the
first \code{rolloffParabHarm} harmonics. The middle harmonic
of the first \code{rolloffParabHarm} harmonics is amplified or
dampened by \code{rolloffParab} dB relative to the basic
exponential decay.}

\item{rolloffParabHarm}{the number of harmonics affected by
\code{rolloffParab}}

\item{rolloff_perAmpl}{as amplitude goes down from max to
\code{throwaway}, \code{rolloff} increases by \code{rolloff_perAmpl}
dB/octave. The effect is to make loud parts brighter by increasing energy
in higher frequencies}

\item{temperature}{hyperparameter for regulating the amount of stochasticity
in sound generation}

\item{pitchDriftDep}{scale factor regulating the effect of temperature on the
amount of slow random drift of f0 (like jitter, but slower): the higher,
the more f0 "wiggles" at a given temperature}

\item{pitchDriftFreq}{scale factor regulating the effect of temperature on
the frequency of random drift of f0 (like jitter, but slower): the higher,
the faster f0 "wiggles" at a given temperature}

\item{randomWalk_trendStrength}{try 0 to 1 - the higher, the more likely rw
is to get high in the middle and low at the beginning and end (i.e. max
effect amplitude in the middle of a sound)}

\item{shortestEpoch}{minimum duration of each epoch with unchanging
subharmonics regime, in ms}

\item{subFreq}{target frequency of subharmonics, Hz (lower than f0, adjusted
dynamically so f0 is always a multiple of subFreq)}

\item{subDep}{the width of subharmonic band, Hz. Regulates how quickly the
strength of subharmonics fades as they move away from harmonics in f0
stack. Low values produce narrow sidebands, high values produce uniformly
strong subharmonics}

\item{amplAnchors}{a numeric vector of amplitude envelope (0 to 1) or a
dataframe specifying the time (ms) and value of amplitude anchors}

\item{overlap}{FFT window overlap, \%}

\item{samplingRate}{sampling frequency, Hz}

\item{pitchFloor}{lower & upper bounds of f0}

\item{pitchCeiling}{lower & upper bounds of f0}

\item{pitchSamplingRate}{sampling frequency of the pitch contour only, Hz. Low
values reduce processing time. A rule of thumb is to set this to
the same value as \code{pitchCeiling}}

\item{throwaway}{discard harmonics and noise that are quieter than this
number (in dB, defaults to -120) to save computational resources}
}
\description{
Internal soundgen function.
}
\details{
Returns one continuous, unfiltered, voiced syllable consisting of several
sine waves.
}
\examples{
pitch = soundgen:::getSmoothContour(len = 3500,
  anchors = data.frame('time' = c(0, 1), 'value' = c(200, 300)))
plot(pitch)
sound1 = soundgen:::generateHarmonics(pitch, samplingRate = 16000)
#' # playme(sound1, samplingRate = 16000) # no formants yet
sound2 = soundgen:::generateHarmonics(pitch, samplingRate = 16000, glottisAnchors = c(0, 300))
#' # playme(sound2, samplingRate = 16000) # pauses between glottal cycles
}
\keyword{internal}
