% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{killDC}
\alias{killDC}
\title{Kill envelope}
\usage{
killDC(sound, windowLength = 200, samplingRate = 16000,
  windowLength_points = NULL, plot = FALSE)
}
\arguments{
\item{sound}{input vector oscillating about zero}

\item{windowLength}{the length of smoothing window, ms}

\item{samplingRate}{the sampling rate, Hz. Only needed if the length of
smoothing window is specified in ms rather than points}

\item{windowLength_points}{the length of smoothing window, points. If
specified, overrides both \code{windowLength} and \code{samplingRate}}

\item{plot}{if TRUE, plots the original sound, smoothed moving average, and
modified sound}
}
\description{
Removes DC offset or similar disbalance in a waveform dynamically, by
subtracting a smoothed ~moving average. Simplified compared to a true moving
average, but very fast (a few ms per second of 44100 audio).
}
\examples{
# remove static DC offset
a = rnorm(500) + .3
b = soundgen:::killDC(a, windowLength_points = 500, plot = TRUE)

# remove trend
a = rnorm(500) + seq(0, 1, length.out = 500)
b = soundgen:::killDC(a, windowLength_points = 100, plot = TRUE)

# can also be used as a high-pass filter
a = rnorm(500) + sin(1:500 / 50)
b = soundgen:::killDC(a, windowLength_points = 25, plot = TRUE)
}
