% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subharmonics.R
\name{getVocalFry_per_epoch}
\alias{getVocalFry_per_epoch}
\title{Constant subharmonics regime}
\usage{
getVocalFry_per_epoch(rolloff, pitch_per_gc, nSubharm, sideband_width_vector,
  throwaway01)
}
\arguments{
\item{rolloff}{matrix of original amplitudes of each harmonic in f0 stack
returned by \code{\link{getRolloff}} (columns=time, rows=frequency bins)}

\item{pitch_per_gc}{vector of the same length as ncol(rolloff)): f0 in Hz,
one value per glottal cycle}

\item{nSubharm}{the number of subharmonics to generate (a positive integer).
If nSubharm==1, subFreq = f0 / 2. If nSubharm==2, subFreq = f0 / 3 and 2 * f0 / 3.
Etc}

\item{sideband_width_vector}{(either numeric or vector of the same length as
pitch_per_gc): regulates how quickly the strength of subharmonics fades as
they move away from harmonics in f0 stack. Low values produce narrow
sidebands, high values produce uniformly strong subharmonics}

\item{throwaway01}{discard harmonics that are weaker than this number (between
0 and 1) to save computational resources}
}
\value{
Returns a modified rolloff matrix with added subharmonics
}
\description{
Internal soundgen function.
}
\details{
Helper function for adding vocal fry (subharmonics) to a single epoch, with
unchanging subharmonics regime (fixed number of subharmonics and sideband
width). See master function \code{\link{getVocalFry}}.
}
\keyword{internal}
