% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_analyze.R
\name{getPitchAutocor}
\alias{getPitchAutocor}
\title{Autocorrelation pitch tracker}
\usage{
getPitchAutocor(autoCorrelation, autocorSmooth = NULL, autocorThres,
  pitchFloor, pitchCeiling, samplingRate, nCands)
}
\arguments{
\item{autoCorrelation}{pre-calculated autocorrelation of the input frame
(computationally more efficient than to do it here)}

\item{autocorSmooth}{the width of smoothing interval (in bins) for
finding peaks in the autocorrelation function. Defaults to 7 for sampling
rate 44100 and smaller odd numbers for lower values of sampling rate}

\item{autocorThres}{(0 to 1) separate
voicing thresholds for detecting pitch candidates with three different
methods: autocorrelation, cepstrum, and BaNa algorithm (see Details). Note
that HNR is calculated even for unvoiced frames.}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{samplingRate}{sampling rate (Hz)}

\item{nCands}{maximum number of pitch candidates per method (except for
\code{dom}, which returns at most one candidate per frame), normally 1...4}
}
\value{
Returns a list of $HNR (NA or numeric) and $pitchAutocor_array
  (either NULL or a dataframe of pitch candidates).
}
\description{
Internal soundgen function.
}
\details{
Attempts to find F0 of a frame by looking for peaks in the autocorrelation
function (time domain analysis). Modified PRAAT's algorithm. See Boersma, P.
(1993). Accurate short-term analysis of the fundamental frequency and the
harmonics-to-noise ratio of a sampled sound. In Proceedings of the institute
of phonetic sciences (Vol. 17, No. 1193, pp. 97-110).
}
\keyword{internal}
