% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{normalizeFolder}
\alias{normalizeFolder}
\title{Normalize folder}
\usage{
normalizeFolder(myfolder, type = c("peak", "rms", "loudness")[1],
  maxAmp = 0, summaryFun = "mean", windowLength = 50, step = NULL,
  overlap = 70, killDC = FALSE, windowDC = 200, savepath = NULL,
  verbose = TRUE)
}
\arguments{
\item{myfolder}{path to folder containing wav/mp3 files}

\item{type}{normalize so the output files has the same peak amplitude
('peak'), root mean square amplitude ('rms'), or subjective loudness in
sone ('loudness')}

\item{maxAmp}{maximum amplitude in dB (0 = max possible, -10 = 10 dB below
max possible, etc.)}

\item{summaryFun}{should the output files have the same mean / median / max
etc rms amplitude or loudness? (summaryFun has no effect if type = 'peak')}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{killDC}{if TRUE, removed DC offset (see also \code{\link{flatEnv}})}

\item{windowDC}{the window for calculating DC offset, ms}

\item{savepath}{full path to where the normalized files should be saved
(defaults to '/normalized')}

\item{verbose}{if TRUE, reports estimated time left}
}
\description{
Normalizes the amplitude of all wav/mp3 files in a folder based on their peak
or RMS amplitude or subjective loudness. This is good for playback
experiments, which require that all sounds should have similar intensity or
loudness.
}
\details{
Algorithm: first all files are rescaled to have the same peak amplitude of
\code{maxAmp} dB. If \code{type = 'peak'}, the process ends here. If
\code{type = 'rms'}, there are two additional steps. First the original RMS
amplitude of all files is calculated per frame by \code{\link{getRMS}}. The
"quietest" sound with the lowest summary RMS value is not modified, so its
peak amplitude remains \code{maxAmp} dB. All the remaining sounds are
rescaled linearly, so that their summary RMS values becomes the same as that
of the "quietest" sound, and their peak amplitudes become smaller,
\code{<maxAmp}. Finally, if \code{type = 'loudness'}, the subjective
loudness of each sound is estimated by \code{\link{getLoudness}}, which
assumes frequency sensitivity typical of human hearing. The following
normalization procedure is similar to that for \code{type = 'rms'}.
}
\examples{
\dontrun{
# put a few short audio files in a folder, eg '~/Downloads/temp'
getRMSFolder('~/Downloads/temp', summaryFun = 'mean')  # different
normalizeFolder('~/Downloads/temp', type = 'rms', summaryFun = 'mean',
  savepath = '~/Downloads/temp/normalized')
getRMSFolder('~/Downloads/temp/normalized', summaryFun = 'mean')  # same
# If the saved audio files are treated as stereo with one channel missing,
# try reconverting with ffmpeg (saving is handled by tuneR::writeWave)
}
}
