% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{transplantEnv}
\alias{transplantEnv}
\title{Transplant envelope}
\usage{
transplantEnv(
  donor,
  samplingRateD,
  recipient,
  samplingRateR = samplingRateD,
  windowLength = 50,
  method = c("hil", "rms", "peak")[1],
  killDC = FALSE,
  dynamicRange = 80,
  plot = FALSE
)
}
\arguments{
\item{donor}{the sound that "donates" the amplitude envelope (numeric vector
- NOT an audio file)}

\item{samplingRateD, samplingRateR}{sampling rate of the donor and recipient,
respectively (if only samplingRateD is provided, samplingRateR is assumed
to be the same)}

\item{recipient}{the sound that needs to have its amplitude envelope adjusted
(numeric vector - NOT an audio file)}

\item{windowLength}{the length of smoothing window, ms}

\item{method}{'hil' for Hilbert envelope, 'rms' for root mean square
amplitude, 'peak' for peak amplitude per window}

\item{killDC}{if TRUE, dynamically removes DC offset or similar deviations of
average waveform from zero}

\item{dynamicRange}{parts of sound quieter than \code{-dynamicRange} dB will
not be amplified}

\item{plot}{if TRUE, plots the original sound, smoothed envelope, and
flattened sound}
}
\value{
Returns the recipient sound with the donor's amplitude envelope - a
  numeric vector with the same sampling rate as the recipient
}
\description{
Extracts a smoothed amplitude envelope of the \code{donor} sound and applies
it to the \code{recipient} sound. Both sounds are provided as numeric
vectors; they can differ in length and sampling rate. Note that the result
depends on the amount of smoothing (controlled by \code{windowLength}) and
the chosen method of calculating the envelope. Very similar to
\code{\link[seewave]{setenv}}, but with a different smoothing algorithm and
with a choice of several types of envelope: hil, rms, or peak.
}
\examples{
donor = rnorm(500) * seq(1, 0, length.out = 500)
recipient = soundgen(sylLen = 600, addSilence = 50)
transplantEnv(donor, samplingRateD = 200,
               recipient, samplingRateR = 16000,
               windowLength = 50, method = 'hil', plot = TRUE)
transplantEnv(donor, samplingRateD = 200,
               recipient, samplingRateR = 16000,
               windowLength = 10, method = 'peak', plot = TRUE)
}
\seealso{
\code{\link{flatEnv}}, \code{\link[seewave]{setenv}}
}
