% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen_utilities.R
\name{silenceSegments}
\alias{silenceSegments}
\title{Silence sound segments}
\usage{
silenceSegments(x, samplingRate, na_seg, attackLen = 50)
}
\arguments{
\item{x}{sound as a numeric vector}

\item{samplingRate}{sampling rate, Hz}

\item{na_seg}{dataframe containing columns "start_prop" and "end_prop"}

\item{attackLen}{attack length, ms}
}
\description{
Internal soundgen function
}
\details{
Fills specified segments with silence (0) and fades in-out the ends of the
silenced segment.
}
\examples{
s = runif(4000) * 2 - 1
s1 = soundgen:::silenceSegments(s, 16000,
       na_seg = data.frame(prop_start = c(.1, .5), prop_end = c(.2, .85)),
       attackLen = c(5, 15))
osc(s1)
}
\keyword{internal}
