% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen_utilities.R
\name{divideIntoSyllables}
\alias{divideIntoSyllables}
\title{Syllable structure of a bout}
\usage{
divideIntoSyllables(
  nSyl,
  sylLen,
  pauseLen,
  sylDur_min = 20,
  sylDur_max = 10000,
  pauseDur_min = 20,
  pauseDur_max = 1000,
  temperature = 0.025,
  invalidArgAction = c("adjust", "abort", "ignore")[1],
  plot = FALSE
)
}
\arguments{
\item{nSyl}{the desired number of syllables}

\item{sylLen}{the desired mean syllable duration, in ms (vectorized)}

\item{pauseLen}{the desired mean pause between syllables, in ms (vectorized)}

\item{sylDur_min, sylDur_max}{the lower and upper bounds on possible syllable
duration, in ms}

\item{pauseDur_min, pauseDur_max}{the lower and upper bounds on possible pause
duration, in ms}

\item{temperature}{a non-negative float regulating the stochasticity of
syllable segmentation; 0 = no stochasticity; 1 = sd of proposals is equal
to sylLen (very strong stochasticity)}

\item{invalidArgAction}{what to do if an argument is invalid or outside the
range in \code{permittedValues}: 'adjust' = reset to default value, 'abort'
= stop execution, 'ignore' = throw a warning and continue (may crash)}

\item{plot}{produce a plot of syllable structure?}
}
\value{
Returns a matrix with a list of start-end points for syllables
}
\description{
Internal soundgen function.
}
\details{
Stochastic generation of syllable structure of a bout. Calls
\code{\link{rnorm_truncated2}} to vary the duration of each new syllable and of
pauses between syllables. Total bout duration will also vary, unless
temperature is zero. However, the output will always contain exactly
\code{nSyl} syllables.
}
\examples{
soundgen:::divideIntoSyllables(nSyl = 1, sylLen = 180)
soundgen:::divideIntoSyllables(nSyl = 5, sylLen = 180,
  pauseLen = 55, temperature = 0.2, plot = TRUE)
soundgen:::divideIntoSyllables(nSyl = 5, sylLen = 180,
  pauseLen = 55, temperature = 0)
soundgen:::divideIntoSyllables(nSyl = 3, sylLen = 100,
  pauseLen = 25, temperature = 0.5)

# sylLen and pauseLen are vectorized:
soundgen:::divideIntoSyllables(nSyl = 15, sylLen = 100:200,
  pauseLen = c(80, 25, 80), temperature = 0.05, plot = TRUE)
}
\keyword{internal}
