% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum_utilities.R
\name{specToMS_1D}
\alias{specToMS_1D}
\title{Spectrogram to modulation spectrum 1D}
\usage{
specToMS_1D(
  fb,
  samplingRate,
  windowLength = 250,
  step = windowLength/2,
  method = c("spec", "meanspec")[2]
)
}
\arguments{
\item{fb}{input spectrogram (numeric matrix with frequency in rows and time
in columns)}

\item{samplingRate}{for auditory spectrogram, the sampling rate of input
audio; for STFT spectrograms, the number of STFT frames per second}

\item{windowLength, step}{determine the resolution of modulation spectra (both
in ms)}

\item{method}{calls either \code{\link[seewave]{meanspec}} or
\code{\link[seewave]{spec}}}
}
\value{
Returns a modulation spectrum - a matrix of real values, with center
  frequencies of original filters in rows and modulation frequencies in
  columns.
}
\description{
Takes a spectrogram and returns the spectrum of each channel. The input can
be an ordinary STFT spectrogram or an auditory spectrogram (a signal
convolved with a bank of bandpass filters). The difference from
\code{\link{specToMS}} is that, instead of taking a two-dimensional transform
of the spectrogram, here the spectra are calculated independently for each
frequency bin.
}
\examples{
data(sheep, package = 'seewave')

# auditory spectrogram
as = audSpectrogram(sheep, filterType = 'butterworth',
  nFilters = 24, plot = FALSE)
fb = t(do.call(cbind, as$filterbank_env))
rownames(fb) = names(as$filterbank_env)
ms = soundgen:::specToMS_1D(fb, sheep@samp.rate)
plotMS(log(ms+.01), logWarpX = c(10, 2), quantile = NULL, ylab = 'kHz')

# ordinary STFT spectrogram
sp = spectrogram(sheep, windowLength = 15, step = 0.5,
  output = 'original', plot = FALSE)
ms2 = soundgen:::specToMS_1D(sp, 1000 / 0.5)  # 1000/0.5 frames per s
plotMS(log(ms2+.01), quantile = NULL, ylab = 'kHz')
\dontrun{
ms_spec = soundgen:::specToMS_1D(fb, sheep@samp.rate, method = 'spec')
plotMS(log(ms_spec+.01), logWarpX = c(10, 2), quantile = NULL, ylab = 'kHz')
}
}
