% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{RVAR}
\alias{RVAR}
\title{Estimate regime-dependent VAR}
\usage{
RVAR(
  data,
  horizon = 10,
  freq = "month",
  type = "const",
  p = 1,
  lag.ic = NULL,
  lag.max = NULL,
  regime = NULL,
  regime.method = "rf",
  regime.n = 2
)
}
\arguments{
\item{data}{data.frame, matrix, ts, xts, zoo: Endogenous regressors}

\item{horizon}{int: forecast horizons}

\item{freq}{string: frequency of data ('day', 'week', 'month', 'quarter', or 'year')}

\item{type}{string: type of deterministic terms to add ('none', 'const', 'trend', or 'both')}

\item{p}{int: lags}

\item{lag.ic}{string: information criterion to choose the optimal number of lags ('AIC' or 'BIC')}

\item{lag.max}{int: maximum number of lags to test in lag selection}

\item{regime}{string: name or regime assignment vector in the design matrix (data)}

\item{regime.method}{string: regime assignment technique ('rf', 'kmeans', 'EM', or 'BP')}

\item{regime.n}{int: number of regimes to estimate (applies to kmeans and EM)}
}
\value{
list of lists, each regime returns its own list with elements \code{data}, \code{model}, \code{forecasts}, \code{residuals}
}
\description{
Estimate regime-dependent VAR
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)
 Data = dplyr::mutate(Data, reg = dplyr::if_else(AA > median(AA), 1, 0))

 # estimate VAR
  rvar =
    sovereign::RVAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      regime.method = 'rf',
      regime.n = 2,
      lag.ic = 'BIC',
      lag.max = 4)

# impulse response functions
rvar.irf = sovereign::rvar_irf(rvar)

# forecast error variance decomposition
rvar.fevd = sovereign::rvar_fevd(rvar)

}

}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_irf]{var_irf()}}

\code{\link[=var_fevd]{var_fevd()}}

\code{\link[=RVAR]{RVAR()}}

\code{\link[=rvar_irf]{rvar_irf()}}

\code{\link[=rvar_fevd]{rvar_fevd()}}
}
