#' Extract the wrapped model of the best performing features from an spFSR object
#'
#' @description Returns a fitted model which uses the best performing feature subset
#' generated by spFSR. It inherits all methods or functions applied to a \code{WrappedModel} objects.
#' For example, the \code{predict} function can be used on the fitted model.
#' If it is a classifcation model, a confusion matrix can be obtained by calling
#' the \link[mlr]{calculateConfusionMatrix} function. See \link[spFSR]{spFeatureSelection}
#' for a more detailed example.
#'
#' @param x an \code{spFSR} object
#' @return A \code{WrappedModel} object of the best performing features.

#'
#' @seealso \link[spFSR]{spFeatureSelection}
#'
#' @author Yong Kai Wong \email{yongkai1017@gmail.com}
#'
#' @export
getBestModel <- function(x){
  if( !inherits(x, 'spFSR')  ){
    stop('Not a spFSR object.')
  }
  x$best.model
}
