.hack_options_error <- local({
  .R_errorfn_or_expr <- NULL ## keep original error-handling function, "stop" or "recover" or rstudio stuff
  .message <- NULL ## the message to show when an error occurs
  function(message=NULL) {
    if ( ! is.null(message)) {
      if (is.null(.R_errorfn_or_expr)) { ## Do not call options("error"=errorfn) twice !
        # see ?options for error:
        # either a function or an expression governing the handling of non-catastrophic errors such as those generated by 
        # stop as well as by signals and internally detected errors. If the option is a function, a call to that function, 
        # with no arguments, is generated as the expression.
        .R_errorfn_or_expr <- loc_call_or_expr <- getOption("error") ## original error-handling function call: save it to be able to restore it,
        if ( class(loc_call_or_expr) =="call") { # The messy thing is that if one assigns as function, one gets a call...
          .R_errorfn_or_expr <<- .R_errorfn_or_expr[[1]]
        } else if ( class(loc_call_or_expr) =="{") { # quoted expression in which case .R_errorfn[[1L]] does not work.
          # stop("It looks like option 'error' has been set to quote({<.>}), but it should be set to function() {<.>} ")
        } ## yet another valid class is "NULL"...
        # and make a local copy for (R CMD check not complaining about) the following definition:
        errorWrap <- function() {
          message(paste0("An error occurred, possibly due to the following earlier issue:\n", .message))
          options(error=.R_errorfn_or_expr) 
          eval(loc_call_or_expr) ## stop or recover or quoted expression
        }
        options("error"=errorWrap) 
      }
      .message <<- message ## possibly updating the message.
    } else if ( ! is.null(.R_errorfn_or_expr)) { ## cleans everything
      options("error"=.R_errorfn_or_expr) ## [[]] gets the original error-handling function (without the trailing '()') from the call and restores it
      .R_errorfn_or_expr <<- NULL
      .message <<- NULL
    }
  }
})