% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_io.R
\name{read_mrs}
\alias{read_mrs}
\title{Read MRS data from a file.}
\usage{
read_mrs(
  fname,
  format = NULL,
  ft = NULL,
  fs = NULL,
  ref = NULL,
  n_ref_scans = NULL,
  full_data = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{fname}{filename of the dpt format MRS data.}

\item{format}{string describing the data format. Must be one of the
following : "spar_sdat", "rda", "ima", "twix", "pfile", "list_data",
"paravis", "dpt", "lcm_raw", "rds", "nifti", "varian". If not specified,
the format will be guessed from the filename extension.}

\item{ft}{transmitter frequency in Hz (required for list_data format).}

\item{fs}{sampling frequency in Hz (required for list_data format).}

\item{ref}{reference value for ppm scale (required for list_data format).}

\item{n_ref_scans}{override the number of water reference scans detected in
the file header (GE p-file only).}

\item{full_data}{export all data points, including those before the start of
the FID (default = FALSE).}

\item{verbose}{print data file information (default = FALSE).}
}
\value{
MRS data object.
}
\description{
Read MRS data from a file.
}
\examples{
fname <- system.file("extdata", "philips_spar_sdat_WS.SDAT", package = "spant")
mrs_data <- read_mrs(fname)
print(mrs_data)
}
