/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.hive.HiveContext;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Try$;
import sparklyr.Backend;
import sparklyr.Backend$;
import sparklyr.Backend$GatewayOperattions$;
import sparklyr.Logging$;

public final class Backend$ {
    public static final Backend$ MODULE$;
    public boolean sparklyr$Backend$$isService;
    public boolean sparklyr$Backend$$isRemote;
    private ServerSocket gatewayServerSocket;
    private int port;
    public int sparklyr$Backend$$sessionId;
    private SparkContext sc;
    private HiveContext hc;
    public Map<Object, Object> sparklyr$Backend$$sessionsMap;
    private InetAddress inetAddress;

    static {
        new Backend$();
    }

    public HiveContext getOrCreateHiveContext(SparkContext sc) {
        if (this.hc == null) {
            this.hc = new HiveContext(sc);
        }
        return this.hc;
    }

    public SparkContext getSparkContext() {
        return this.sc;
    }

    public void setSparkContext(SparkContext nsc) {
        this.sc = nsc;
    }

    public boolean portIsAvailable(int port) {
        ObjectRef ss = ObjectRef.create(null);
        BooleanRef available = BooleanRef.create((boolean)false);
        Try$.MODULE$.apply((Function0)new Serializable(port, ss, available){
            public static final long serialVersionUID = 0L;
            private final int port$1;
            private final ObjectRef ss$1;
            private final BooleanRef available$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.ss$1.elem = new ServerSocket(this.port$1, 1, InetAddress.getByName("localhost"));
                this.available$1.elem = true;
            }
            {
                this.port$1 = port$1;
                this.ss$1 = ss$1;
                this.available$1 = available$1;
            }
        });
        Object object = (ServerSocket)ss.elem == null ? BoxedUnit.UNIT : Try$.MODULE$.apply((Function0)new Serializable(ss){
            public static final long serialVersionUID = 0L;
            public final ObjectRef ss$1;

            public final void apply() {
                ((ServerSocket)this.ss$1.elem).close();
            }

            public void apply$mcV$sp() {
                ((ServerSocket)this.ss$1.elem).close();
            }
            {
                this.ss$1 = ss$1;
            }
        });
        return available.elem;
    }

    /*
     * Unable to fully structure code
     */
    public void main(String[] args) {
        if (args.length > 4 || args.length < 2) {
            System.err.println("Usage: Backend port id [--service] [--remote]\n  port:      port the gateway will listen to\n  id:        arbitrary numeric identifier for this backend session\n  --service: prevents closing the connection from closing the backen\n  --remote:  allows the gateway running as service to accept remote connections");
            System.exit(-1);
        }
        var3_2 = args[0];
        var2_3 = Predef$.MODULE$;
        this.port = new StringOps(var3_2).toInt();
        var5_4 = args[1];
        var4_5 = Predef$.MODULE$;
        this.sparklyr$Backend$$sessionId = new StringOps(var5_4).toInt();
        if (args.length <= 2) ** GOTO lbl-1000
        v0 = args[2];
        if (v0 != null && v0.equals("--service")) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = this.sparklyr$Backend$$isService = false;
        }
        if (args.length <= 3) ** GOTO lbl-1000
        v2 = args[3];
        if (v2 != null && v2.equals("--remote")) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = this.sparklyr$Backend$$isRemote = false;
        }
        if (this.sparklyr$Backend$$isRemote) {
            anyIpAddress = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
            this.inetAddress = InetAddress.getByAddress(anyIpAddress);
        }
        Logging$.MODULE$.log(new StringBuilder().append((Object)"Session (").append((Object)BoxesRunTime.boxToInteger((int)this.sparklyr$Backend$$sessionId)).append((Object)") starting").toString());
        try {
            if (this.portIsAvailable(this.port)) {
                this.gatewayServerSocket = new ServerSocket(this.port, 1, this.inetAddress);
            } else {
                this.gatewayServerSocket = new ServerSocket(0, 1, this.inetAddress);
                gatewayPort = this.port;
                this.port = this.gatewayServerSocket.getLocalPort();
                success = this.register(gatewayPort, this.sparklyr$Backend$$sessionId, this.port);
                if (!success) {
                    Logging$.MODULE$.logError(new StringBuilder().append((Object)"Failed to register sparklyr session (").append((Object)BoxesRunTime.boxToInteger((int)this.sparklyr$Backend$$sessionId)).append((Object)") to gateway port (").append((Object)BoxesRunTime.boxToInteger((int)gatewayPort)).append((Object)")").toString());
                    System.exit(1);
                }
            }
            this.gatewayServerSocket.setSoTimeout(0);
            while (true) {
                this.bind();
            }
        }
        catch (IOException var9_9) {
            Logging$.MODULE$.logError("Server shutting down: failed with exception ", var9_9);
            System.exit(1);
            System.exit(0);
            return;
        }
    }

    public void bind() {
        Socket gatewaySocket = this.gatewayServerSocket.accept();
        byte[] buf = new byte[1024];
        new Thread(gatewaySocket, buf){
            public final Socket gatewaySocket$1;
            private final byte[] buf$1;

            public void run() {
                block11: {
                    try {
                        Backend backend;
                        Enumeration.Value value;
                        block14: {
                            block13: {
                                DataInputStream dis;
                                block12: {
                                    Object object;
                                    dis = new DataInputStream(this.gatewaySocket$1.getInputStream());
                                    int commandId = dis.readInt();
                                    Logging$.MODULE$.log(new StringBuilder().append((Object)"Gateway received command identifier (").append((Object)BoxesRunTime.boxToInteger((int)commandId)).append((Object)")").toString());
                                    value = Backend$GatewayOperattions$.MODULE$.apply(commandId);
                                    Enumeration.Value value2 = Backend$GatewayOperattions$.MODULE$.GetPorts();
                                    if (value2 != null ? !value2.equals(value) : value != null) break block12;
                                    int requestedSessionId = dis.readInt();
                                    int startupTimeout = dis.readInt();
                                    DataOutputStream dos = new DataOutputStream(this.gatewaySocket$1.getOutputStream());
                                    if (requestedSessionId == Backend$.MODULE$.sparklyr$Backend$$sessionId || requestedSessionId == 0) {
                                        Logging$.MODULE$.log(new StringBuilder().append((Object)"Gateway found current session (").append((Object)BoxesRunTime.boxToInteger((int)Backend$.MODULE$.sparklyr$Backend$$sessionId)).append((Object)")").toString());
                                        backend = new Backend();
                                        int backendPort = backend.init(Backend$.MODULE$.sparklyr$Backend$$isRemote);
                                        Logging$.MODULE$.log(new StringBuilder().append((Object)"Gateway created backend for session (").append((Object)BoxesRunTime.boxToInteger((int)Backend$.MODULE$.sparklyr$Backend$$sessionId)).append((Object)")").toString());
                                        new Thread(this, dos, backend, backendPort){
                                            private final /* synthetic */ anon.2 $outer;
                                            private final DataOutputStream dos$1;
                                            private final Backend backend$1;
                                            private final int backendPort$1;

                                            public void run() {
                                                block2: {
                                                    try {
                                                        this.dos$1.writeInt(Backend$.MODULE$.sparklyr$Backend$$sessionId);
                                                        this.dos$1.writeInt(this.$outer.gatewaySocket$1.getLocalPort());
                                                        this.dos$1.writeInt(this.backendPort$1);
                                                        this.backend$1.run();
                                                    }
                                                    catch (IOException iOException) {
                                                        Logging$.MODULE$.logError("Backend failed with exception ", iOException);
                                                        if (Backend$.MODULE$.sparklyr$Backend$$isService) break block2;
                                                        System.exit(1);
                                                    }
                                                }
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.dos$1 = dos$1;
                                                this.backend$1 = backend$1;
                                                this.backendPort$1 = backendPort$1;
                                                super("run backend");
                                                this.setDaemon(true);
                                            }
                                        }.start();
                                        Logging$.MODULE$.log(new StringBuilder().append((Object)"Gateway waiting for r process to end in session (").append((Object)BoxesRunTime.boxToInteger((int)requestedSessionId)).append((Object)")").toString());
                                        object = BoxesRunTime.boxToInteger((int)this.gatewaySocket$1.getInputStream().read(this.buf$1));
                                    }
                                    Logging$.MODULE$.log(new StringBuilder().append((Object)"Gateway searching for session (").append((Object)BoxesRunTime.boxToInteger((int)requestedSessionId)).append((Object)")").toString());
                                    Option portForSession = Backend$.MODULE$.sparklyr$Backend$$sessionsMap.get((Object)BoxesRunTime.boxToInteger((int)requestedSessionId));
                                    for (int sessionMapRetries = startupTimeout * 10; !portForSession.isDefined() && sessionMapRetries > 0; --sessionMapRetries) {
                                        portForSession = Backend$.MODULE$.sparklyr$Backend$$sessionsMap.get((Object)BoxesRunTime.boxToInteger((int)requestedSessionId));
                                        Thread.sleep(100L);
                                    }
                                    if (portForSession.isDefined()) {
                                        Logging$.MODULE$.log(new StringBuilder().append((Object)"Gateway found mapping for session (").append((Object)BoxesRunTime.boxToInteger((int)requestedSessionId)).append((Object)")").toString());
                                        dos.writeInt(requestedSessionId);
                                        dos.writeInt(BoxesRunTime.unboxToInt((Object)portForSession.get()));
                                        dos.writeInt(0);
                                    } else {
                                        Logging$.MODULE$.log(new StringBuilder().append((Object)"Gateway found no mapping for session (").append((Object)BoxesRunTime.boxToInteger((int)requestedSessionId)).append((Object)")").toString());
                                        dos.writeInt(requestedSessionId);
                                        dos.writeInt(0);
                                        dos.writeInt(0);
                                    }
                                    object = BoxedUnit.UNIT;
                                    dos.close();
                                    break block13;
                                }
                                Enumeration.Value value3 = Backend$GatewayOperattions$.MODULE$.RegisterInstance();
                                if (value3 != null ? !value3.equals(value) : value != null) break block14;
                                int registerSessionId = dis.readInt();
                                int registerGatewayPort = dis.readInt();
                                Logging$.MODULE$.log(new StringBuilder().append((Object)"Gateway registering session (").append((Object)BoxesRunTime.boxToInteger((int)registerSessionId)).append((Object)") for port (").append((Object)BoxesRunTime.boxToInteger((int)registerGatewayPort)).append((Object)")").toString());
                                DataOutputStream dos = new DataOutputStream(this.gatewaySocket$1.getOutputStream());
                                dos.writeInt(0);
                                dos.flush();
                                dos.close();
                                Integer n = BoxesRunTime.boxToInteger((int)registerGatewayPort);
                                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)registerSessionId));
                                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                                Backend$.MODULE$.sparklyr$Backend$$sessionsMap = Backend$.MODULE$.sparklyr$Backend$$sessionsMap.$plus(new Tuple2(object, (Object)n));
                            }
                            this.gatewaySocket$1.close();
                            break block11;
                        }
                        throw new MatchError((Object)value);
                        finally {
                            backend.close();
                            if (!Backend$.MODULE$.sparklyr$Backend$$isService) {
                                Logging$.MODULE$.log("Terminating sparklyr backend");
                                System.exit(0);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        Logging$.MODULE$.logError("Backend failed with exception ", iOException);
                        if (Backend$.MODULE$.sparklyr$Backend$$isService) break block11;
                        System.exit(1);
                    }
                }
            }
            {
                this.gatewaySocket$1 = gatewaySocket$1;
                this.buf$1 = buf$1;
                super("wait for monitor to close");
                this.setDaemon(true);
            }
        }.start();
    }

    public boolean register(int gatewayPort, int sessionId, int port) {
        Logging$.MODULE$.log(new StringBuilder().append((Object)"Registering session (").append((Object)BoxesRunTime.boxToInteger((int)sessionId)).append((Object)") into gateway port (").append((Object)BoxesRunTime.boxToInteger((int)gatewayPort)).append((Object)")").toString());
        Socket s = new Socket(InetAddress.getByName("localhost"), gatewayPort);
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        dos.writeInt(Backend$GatewayOperattions$.MODULE$.RegisterInstance().id());
        dos.writeInt(sessionId);
        dos.writeInt(port);
        Logging$.MODULE$.log(new StringBuilder().append((Object)"Waiting for registration of (").append((Object)BoxesRunTime.boxToInteger((int)sessionId)).append((Object)") into gateway port (").append((Object)BoxesRunTime.boxToInteger((int)gatewayPort)).append((Object)")").toString());
        DataInputStream dis = new DataInputStream(s.getInputStream());
        int status = dis.readInt();
        Logging$.MODULE$.log(new StringBuilder().append((Object)"Finished registration of session (").append((Object)BoxesRunTime.boxToInteger((int)sessionId)).append((Object)") into gateway port (").append((Object)BoxesRunTime.boxToInteger((int)gatewayPort)).append((Object)") with status (").append((Object)BoxesRunTime.boxToInteger((int)status)).append((Object)")").toString());
        s.close();
        return status == 0;
    }

    private Backend$() {
        MODULE$ = this;
        this.sparklyr$Backend$$isService = false;
        this.sparklyr$Backend$$isRemote = false;
        this.gatewayServerSocket = null;
        this.port = 0;
        this.sparklyr$Backend$$sessionId = 0;
        this.sc = null;
        this.hc = null;
        this.sparklyr$Backend$$sessionsMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.inetAddress = InetAddress.getByName("localhost");
    }
}

