% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_tuning.R, R/ml_tuning_cross_validator.R,
%   R/ml_tuning_train_validation_split.R
\name{ml-tuning}
\alias{ml-tuning}
\alias{ml_cross_validator}
\alias{ml_train_validation_split}
\title{Spark ML -- Tuning}
\usage{
ml_cross_validator(x, estimator, estimator_param_maps, evaluator,
  num_folds = 3L, seed = NULL, uid = random_string("cross_validator_"),
  ...)

ml_train_validation_split(x, estimator, estimator_param_maps, evaluator,
  train_ratio = 0.75, seed = NULL,
  uid = random_string("train_validation_split_"), ...)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{estimator}{A \code{ml_estimator} object.}

\item{estimator_param_maps}{A named list of stages and hyper-parameter sets to tune. See details.}

\item{evaluator}{A \code{ml_evaluator} object, see \link{ml_evaluator}.}

\item{num_folds}{Number of folds for cross validation. Must be >= 2. Default: 3}

\item{seed}{A random seed. Set this value if you need your results to be
reproducible across repeated calls.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; currently unused.}

\item{train_ratio}{Ratio between train and validation data. Must be between 0 and 1. Default: 0.75}
}
\value{
The object returned depends on the class of \code{x}.

\itemize{
  \item \code{spark_connection}: When \code{x} is a \code{spark_connection}, the function returns an instance of a \code{ml_cross_validator} or \code{ml_traing_validation_split} object.

  \item \code{ml_pipeline}: When \code{x} is a \code{ml_pipeline}, the function returns a \code{ml_pipeline} with
  the tuning estimator appended to the pipeline.

  \item \code{tbl_spark}: When \code{x} is a \code{tbl_spark}, a tuning estimator is constructed then
  immediately fit with the input \code{tbl_spark}, returning a \code{ml_cross_validation_model} or a
  \code{ml_train_validation_split_model} object.
}
}
\description{
Perform hyper-parameter tuning using either K-fold cross validation or train-validation split.
}
\details{
\code{ml_cross_validator()} performs k-fold cross validation while \code{ml_train_validation_split()} performs tuning on one pair of train and validation datasets.
}
