% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girf.R
\name{girf}
\alias{girf}
\alias{girf-missing}
\alias{girf,missing-method}
\alias{girf-ANY}
\alias{girf,ANY-method}
\alias{girf-spatPomp}
\alias{girf,spatPomp-method}
\alias{girf-girfd_spatPomp}
\alias{girf,girfd_spatPomp-method}
\title{Guided intermediate resampling filter (GIRF)}
\usage{
\S4method{girf}{missing}(object, ...)

\S4method{girf}{ANY}(object, ...)

\S4method{girf}{spatPomp}(
  object,
  Np,
  Ninter,
  lookahead = 1,
  Nguide,
  kind = c("bootstrap", "moment"),
  tol,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{girf}{girfd_spatPomp}(
  object,
  Np,
  Ninter,
  lookahead,
  Nguide,
  kind = c("bootstrap", "moment"),
  tol,
  ...
)
}
\arguments{
\item{object}{A \code{spatPomp} object.}

\item{...}{If a \code{params} argument is specified, \code{abf} will estimate the likelihood at that parameter set instead of at \code{coef(object)}.}

\item{Np}{The number of particles used within each replicate for the adapted simulations.}

\item{Ninter}{the number of intermediate resampling time points. By default, this is set equal to the number of units.}

\item{lookahead}{The number of future observations included in the guide function.}

\item{Nguide}{The number of simulations used to estimate state process uncertainty for each particle.}

\item{kind}{One of two types of guide function construction. Defaults to \code{'bootstrap'}. See Park and Ionides (2020) for more details.}

\item{tol}{If all of the guide function evaluations become too small (beyond floating-point precision limits), we set them to this value.}

\item{verbose}{logical; if \code{TRUE}, messages updating the user on progress will be printed to the console.}
}
\value{
Upon successful completion, \code{girf()} returns an object of class
\sQuote{girfd_spatPomp} which contains the algorithmic parameters that were used to
run \code{girf()} and the resulting log likelihood estimate.
}
\description{
An implementation of the algorithm of Park and Ionides (2020),
following the pseudocode in Asfaw et al. (2020).
}
\section{Methods}{

The following methods are available for such an object:
\describe{
\item{\code{\link{logLik}}}{ yields an unbiased estimate of the log-likelihood of the data under the model. }
}
}

\examples{
# Complete examples are provided in the package tests
\dontrun{
#
# Create a simulation of a Brownian motion
b <- bm(U=2, N=5)

# Run GIRF
girfd_bm <- girf(b,
                 Np = 10,
                 Ninter = length(unit_names(b)),
                 lookahead = 1,
                 Nguide = 10
)
# Get the likelihood estimate from GIRF
logLik(girfd_bm)

# Compare with the likelihood estimate from particle filter
pfd_bm <- pfilter(b, Np = 10)
logLik(pfd_bm)
}
}
\references{
\park2020

\asfaw2020
}
\seealso{
likelihood maximization algorithms: \code{ienkf()}, \code{igirf()}, \code{iubf()}, \code{ibpf()}

Other likelihood evaluation algorithms: 
\code{\link{abf}()},
\code{\link{abfir}()},
\code{\link{bpfilter}()},
\code{\link{enkf}()}
}
\author{
Kidus Asfaw
}
\concept{likelihood evaluation algorithms}
