% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar.R
\name{sar}
\alias{sar}
\title{Surface Area Ratio}
\usage{
sar(x, s = NULL, ...)
}
\arguments{
\item{x}{raster object}

\item{s}{cell resolution (default is NULL, not needed if projection is in planar units)}

\item{...}{Additional arguments passed to raster::calc}
}
\value{
raster class object of Berry (2002) Surface Area Ratio
}
\description{
Calculates the Berry (2002) Surface Area Ratio based on slope
}
\note{
SAR is calculated as: resolution^2 * cos( (degrees(slope) * (pi / 180)) )
}
\examples{
  library(raster)
  data(elev)
  surface.ratio <- sar(elev, s=90)
  plot(surface.ratio)
    
}
\references{
Berry, J.K. (2002). Use surface area for realistic calculations. Geoworld 15(9):20-1.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
