% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.distance.R
\name{topo.distance}
\alias{topo.distance}
\title{Topographic distance}
\usage{
topo.distance(x, r, echo = FALSE)
}
\arguments{
\item{x}{sp SpatialLinesDataFrame object}

\item{r}{raster class elevation raster}

\item{echo}{(FALSE/TRUE) print progress to screen}
}
\value{
Vector of corrected topographic distances same length as nrow(x)
}
\description{
Calculates topographic corrected distance for a 
             SpatialLinesDataFrame object
}
\note{
This function corrects straight-line (euclidean) distances for 
topographic-slope effect.
}
\examples{
\donttest{     
 library(sp)
 library(raster)
 library(GeNetIt)
 
 # create example data
 data(elev)
   r <- projectRaster(elev, res=c(1000,1000), 
                      crs="+proj=aea +lat_1=29.5 +lat_2=42.5")
   e <- extent(616893.6,714697.3,5001027,5080542)
     elev <- crop(r,e) 
       names(elev) <- "elev"
 pts <- sampleRandom(elev, 10, sp=TRUE)
   pts$ID <- LETTERS[seq( from = 1, to = nrow(pts) )]
   
 graph <- GeNetIt::knn.graph(pts, row.names=pts@data[,"ID"])
   proj4string(graph) <- proj4string(elev)
   head(graph@data)
  
 plot(elev)
   plot(graph, cex=0.5, add=TRUE)
   plot(pts,pch=19,col="red",add=TRUE)
 
 # Calculate topographical distance  
 ( tdist <- topo.distance(graph, elev) )
 
 # Increase in corrected distance
 tdist - graph$length
 
 # Percent increase in corrected distance
 ((tdist - graph$length) / graph$length) * 100

}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
