% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.index.R
\name{proximity.index}
\alias{proximity.index}
\title{Proximity Index}
\usage{
proximity.index(x, y = NULL, min.dist = 0, max.dist = 1000, background = NULL)
}
\arguments{
\item{x}{A polygon class sp or sf object}

\item{y}{Optional column in data containing classes}

\item{min.dist}{Minimum threshold distance}

\item{max.dist}{Maximum neighbor distance}

\item{background}{Optional value in y column indicating background value}
}
\value{
A vector equal to nrow(x) of proximity index values, if a background value is 
specified NA values will be returned in the position(s) of the specified class
}
\description{
Calculates proximity index for a set of polygons
}
\examples{
\donttest{
 library(sf)
 if(require(sp, quietly = TRUE)) {
   data(meuse, package = "sp")
   meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                     agr = "constant")
   meuse <- st_buffer(meuse, dist = meuse$elev * 5)
     meuse$LU <- sample(c("forest","nonforest"), nrow(meuse), 
                       replace=TRUE) 

 # All polygon proximity index 1000 radius	
 ( pidx <- proximity.index(meuse, min.dist = 1) )
   pidx[pidx > 1000] <- 1000
 
 # Class-level proximity index 1000 radius
 ( pidx.class <- proximity.index(meuse, y = "LU", min.dist = 1) )
   
 # plot index for all polygons
 meuse$pidx <- pidx
   plot(meuse["pidx"])
 
 # plot index for class-level polygons 
 meuse$cpidx <- pidx.class
   plot(meuse["cpidx"])
 
 # plot index for just forest class
 forest <- meuse[meuse$LU == "forest",]
  plot(forest["cpidx"])
  }
}   
}
\references{
Gustafson, E.J., & G.R. Parker (1994) Using an Index of Habitat Patch Proximity 
  for Landscape Design. Landscape and Urban Planning 29:117-130
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
