% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.time.series.R
\name{smooth.time.series}
\alias{smooth.time.series}
\title{Smooth Raster Time-series}
\usage{
smooth.time.series(x, f = 0.8, smooth.data = FALSE, ...)
}
\arguments{
\item{x}{A terra SpatRaster with > 8 layers}

\item{f}{Smoothing parameter (see loess span argument)}

\item{smooth.data}{(FALSE/TRUE) Smooth all of the data or just impute NA values}

\item{...}{Additional arguments passed to terra::app (for 
writing results to disk)}
}
\value{
A terra SpatRaster containing imputed or smoothed data.
}
\description{
Smooths pixel-level data in raster time-series and can impute 
             missing (NA) values.
}
\details{
This function uses a LOESS regression to smooth the time-series. If the data is 
smoothed, (using the smooth.data = TRUE argument) it will be entirely replaced by  
a loess estimate of the time-series (estimated distribution at the pixel-level). 
Alternately, with smooth.data = FALSE, the function can be used to impute missing 
pixel data (NA) in raster time-series (stacks/bricks).
The results can dramatically be effected by the choice of the smoothing 
parameter (f) so caution is warranted and the effect of this parameter tested.
}
\examples{
\dontrun{
library(terra)
  random.raster <- function(rows=50, cols=50, l=20, min=0, max=1){ 
    do.call(c, replicate(l, rast(matrix(runif(rows * cols, min, max), 
	        rows , cols))))
  }
r <- random.raster()

#### Smooth time-series using raster stack/brick 
r.smooth <- smooth.time.series(r, f = 0.4, smooth.data = TRUE)  

# extract pixel 100 for plotting
y <- as.numeric(r[100])
ys <- as.numeric(r.smooth[100])

# plot results	
plot(y, type="l")
  lines(ys, col="red")
    legend("bottomright", legend=c("original","smoothed"),
         lty=c(1,1), col=c("black","red"))	
}
}
\seealso{
\code{\link[stats]{loess}} for details on the loess regression

\code{\link[terra]{app}} for details on additional (...) arguments

\code{\link[spatialEco]{impute.loess}} for details on imputation model
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
