% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background.R
\name{background}
\alias{background}
\title{Background sample}
\usage{
background(
  x,
  p = 1000,
  known = NULL,
  d = NULL,
  type = c("regular", "random", "hexagon", "nonaligned")
)
}
\arguments{
\item{x}{A sf class polygon defining sample region}

\item{p}{Size of sample}

\item{known}{An sf POINT class of known locations with same CSR as x}

\item{d}{Threshold distance for known proximity}

\item{type}{Type of sample c("systematic", "random", "hexagon", "nonaligned")}
}
\value{
A sf POINT feature class or data.frame with x,y coordinates
}
\description{
Creates a point sample that can be used as 
             a NULL for SDM's and other modeling approaches.
}
\details{
This function creates a background point sample based on an extent 
or polygon sampling region. The known argument can be used with d 
to remove sample points based on distance-based proximity to existing  
locations (eg., known species locations). The size (p) of the resulting 
sample will be dependent on the known locations and the influence of 
the distance threshold (d). As such, if the know and d arguments are
provided the exact value provided in p will not be returned.
}
\examples{
library(sf)

# define study area
sa <- suppressWarnings(st_cast(st_read(
        system.file("shape/nc.shp", 
        package="sf")), "POLYGON"))
  sa <- sa[10,]

# create "known" locations  
locs <- st_sample(sa, 50)
  st_crs(locs) <- st_crs(sa)

# systematic sample using extent polygon
e <- st_as_sf(st_as_sfc(st_bbox(sa)))
  st_crs(e) <- st_crs(sa)
s <- background(e, p=1000, known=locs, d=1000)
  plot(st_geometry(s), pch=20)
    plot(st_geometry(locs), pch=20, col="red", add=TRUE)

# systematic sample using irregular polygon
s <- background(sa, p=1000, known=locs, d=1000)
  plot(st_geometry(sa)) 
    plot(st_geometry(s), pch=20, add=TRUE)
      plot(st_geometry(locs), pch=20, col="red", add=TRUE)

# random sample using irregular polygon
s <- background(sa, p=500, known=locs, 
                d=1000, type="random")
  plot(st_geometry(sa)) 
    plot(st_geometry(s), pch=20, add=TRUE)
      plot(st_geometry(locs), pch=20, col="red", add=TRUE)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
