% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_specs.r
\name{setup_specs}
\alias{setup_specs}
\title{Set up specifications}
\usage{
setup_specs(x, y, model, controls = NULL)
}
\arguments{
\item{x}{a vector denoting independent variables}

\item{y}{a vector denoting the dependent variables}

\item{model}{a vector denoting the model(s) that should be estimated.}

\item{controls}{a vector of the control variables that should be included. Defaults to NULL.}
}
\value{
a \link[tibble:tibble-package]{tibble} that includes all possible specifications based on combinations of the analytical choices.
}
\description{
This function creates a tibble that includes all possible specifications based the dependent and independent variables, model types, and control variables that are specified. This function simply produces a tibble of all combinations. It can be used to check the specified analytical choices. This function is called within \code{\link[=run_specs]{run_specs()}}, which estimates all specified models based on the data that are provided.
}
\examples{
setup_specs(y = c("y1"),
            x = c("x1", "x2"),
            model = c("lm"),
            controls = c("c1", "c2"))

}
\seealso{
\code{\link[=run_specs]{run_specs()}} to run the specification curve analysis.
}
