/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard.steps;

import at.ac.ait.speedr.importwizard.steps.DataImportPanelUserActionListener;
import at.ac.ait.speedr.importwizard.steps.ImportTableModel;
import at.ac.ait.speedr.importwizard.tablemodel.ImportTableModelHelper;
import at.ac.ait.speedr.table.POSIXctCellRenderer;
import at.ac.ait.speedr.table.RDate;
import at.ac.ait.speedr.table.RDatePickerCellEditor;
import at.ac.ait.speedr.table.RDateTimeConverter;
import at.ac.ait.speedr.table.RDateTimePickerCellEditor;
import at.ac.ait.speedr.table.RPOSIXct;
import at.ac.ait.speedr.table.RTableCellEditor;
import at.ac.ait.speedr.table.RTableCellRenderer;
import at.ac.ait.speedr.workspace.RUtil;
import at.ac.arcs.tablefilter.ARCTable;
import at.ac.arcs.tablefilter.cell.DateCellRenderer;
import at.ac.arcs.tablefilter.events.ColumnSelectorEvent;
import at.ac.arcs.tablefilter.events.ColumnSelectorListener;
import at.ac.arcs.tablefilter.events.ColumnSelectorVetoException;
import at.ac.arcs.tablefilter.events.FilterListener;
import at.ac.arcs.tablefilter.filtermodel.DateFilterDevice;
import at.ac.arcs.tablefilter.filtermodel.FilterDevice;
import at.ac.arcs.tablefilter.ist.ColumnSelectorOption;
import com.google.common.base.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.miginfocom.swing.MigLayout;

public class DataImportPanel
extends JPanel {
    public static final String PROP_DELIMITER = "DELIMITER";
    public static final String PROP_QUALIFIER = "QUALIFIER";
    public static final String PROP_VARIABLENAME = "VARIABLENAME";
    private ImportTableModelHelper tableModelHelper;
    private ImportTableModel tableModel = new ImportTableModel();
    private final TableModelPropertyChangeListener tableModelPropertyChangeListener = new TableModelPropertyChangeListener();
    private DataImportPanelUserActionListener useractionlistener = new DummyUserActionListener();
    private TableModelListener cellUpdateListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0 && e.getColumn() != -1 && e.getColumn() != -1) {
                int row = e.getFirstRow();
                int col = e.getColumn();
                DataImportPanel.this.useractionlistener.tableCellValueChanged(DataImportPanel.this.tableModel.getValueAt(row, col), row, col);
            }
        }
    };
    private boolean updateEnds = true;
    private boolean configPanelEnabled = false;
    ColumnTypeListener columnDataTypeListener = new ColumnTypeListener();
    private JCheckBox cb_ColumnNames;
    private JCheckBox cb_RowNames;
    private JSpinner colEnd;
    private JSpinner colNamesRowIndex;
    private JSpinner colStart;
    private JPanel configurationPanel;
    private ButtonGroup delimiterButtonGroup;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private ButtonGroup quoteButtonGroup;
    private JRadioButton rb_Comma;
    private JRadioButton rb_DoubleQuote;
    private JRadioButton rb_NoDelimiter;
    private JRadioButton rb_NoQuote;
    private JRadioButton rb_OtherDelimiter;
    private JRadioButton rb_OtherQuote;
    private JRadioButton rb_Semicolon;
    private JRadioButton rb_SingleQuote;
    private JRadioButton rb_Space;
    private JRadioButton rb_Tab;
    private JSpinner rowNamesColumnIndex;
    private JSpinner rowsEnd;
    private JSpinner rowsStart;
    private ARCTable table;
    private JTextField tf_OtherDelimiter;
    private JTextField tf_otherQuote;
    private JTextField variablename;

    public DataImportPanel(boolean showConfigurationPanel) {
        this.initComponents();
        this.initTable();
        this.configurationPanel.setVisible(showConfigurationPanel);
        this.tableModel.addPropertyChangeListener(this.tableModelPropertyChangeListener);
        this.tableModel.addTableModelListener(this.cellUpdateListener);
    }

    private void initTable() {
        RTableCellRenderer cr = new RTableCellRenderer(this.table.getDefaultRenderer(Object.class));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)cr);
        this.table.setDefaultRenderer(Integer.class, (TableCellRenderer)cr);
        this.table.setDefaultRenderer(Double.class, (TableCellRenderer)cr);
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)cr);
        this.table.setDefaultRenderer(RDate.class, (TableCellRenderer)new DateCellRenderer());
        this.table.setDefaultRenderer(RPOSIXct.class, (TableCellRenderer)new POSIXctCellRenderer());
        RTableCellEditor editor = new RTableCellEditor(this.table.getDefaultEditor(Object.class));
        this.table.setDefaultEditor(Object.class, (TableCellEditor)editor);
        this.table.setDefaultEditor(Integer.class, (TableCellEditor)editor);
        this.table.setDefaultEditor(Double.class, (TableCellEditor)editor);
        this.table.setDefaultEditor(String.class, (TableCellEditor)editor);
        this.table.setDefaultEditor(RDate.class, (TableCellEditor)((Object)new RDatePickerCellEditor()));
        this.table.setDefaultEditor(RPOSIXct.class, (TableCellEditor)((Object)new RDateTimePickerCellEditor()));
        this.table.registerFilterDevice(RDate.class, (FilterDevice)new DateFilterDevice());
        this.table.registerFilterDevice(RPOSIXct.class, (FilterDevice)new DateFilterDevice());
        this.table.registerConverter(RDate.class, (Function)new RDateTimeConverter());
        this.table.registerConverter(RPOSIXct.class, (Function)new RDateTimeConverter());
        this.table.setFilterRowHeaderVisibleColumnsMask(24);
        this.table.setTableRowHeaderVisibleColumnsMask(2);
        this.table.setGroupingEnabled(false);
        this.table.setColumnSelectorVisible(true);
        this.table.setNoneOptionCaption("");
        ColumnSelectorOption op = new ColumnSelectorOption((Object)ColumnType.NUMERIC, ColumnSelectorOption.OptionType.MANY_TO_ONE);
        op = new ColumnSelectorOption((Object)ColumnType.CHARACTER, ColumnSelectorOption.OptionType.MANY_TO_ONE);
        op = new ColumnSelectorOption((Object)ColumnType.FACTOR, ColumnSelectorOption.OptionType.MANY_TO_ONE);
        op = new ColumnSelectorOption((Object)ColumnType.DATE, ColumnSelectorOption.OptionType.MANY_TO_ONE);
        op = new ColumnSelectorOption((Object)ColumnType.POSIXCT, ColumnSelectorOption.OptionType.MANY_TO_ONE);
        ColumnSelectorOption[] ops = new ColumnSelectorOption[]{op, op, op, op, op};
        this.table.setColumnSelectorOptions(ops);
        this.table.addColumnSelectorListener((ColumnSelectorListener)this.columnDataTypeListener);
    }

    public void setImportTableModelHelper(ImportTableModelHelper tableModelHelper) {
        this.tableModelHelper = tableModelHelper;
    }

    public ImportTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModelToNull() {
        this.table.removeColumnSelectorListener((ColumnSelectorListener)this.columnDataTypeListener);
        this.tableModel.removeTableModelListener(this.cellUpdateListener);
        this.tableModel.removePropertyChangeListener(this.tableModelPropertyChangeListener);
        this.tableModel.clearAll();
        this.tableModel = null;
        this.table = null;
    }

    public ARCTable getARCTable() {
        return this.table;
    }

    public void setConfigurationPanelEnabled(boolean enabled) {
        this.rb_Comma.setEnabled(enabled);
        this.rb_OtherDelimiter.setEnabled(enabled);
        this.tf_OtherDelimiter.setEnabled(enabled);
        this.rb_Semicolon.setEnabled(enabled);
        this.rb_Tab.setEnabled(enabled);
        this.rb_Space.setEnabled(enabled);
        this.rb_DoubleQuote.setEnabled(enabled);
        this.rb_SingleQuote.setEnabled(enabled);
        this.rb_NoQuote.setEnabled(enabled);
        this.rb_OtherQuote.setEnabled(enabled);
        this.tf_otherQuote.setEnabled(enabled);
        this.rowsStart.setEnabled(enabled);
        this.rowsEnd.setEnabled(enabled);
        this.colStart.setEnabled(enabled);
        this.colEnd.setEnabled(enabled);
        this.cb_ColumnNames.setEnabled(enabled && this.tableModel.getRowCount() > 1);
        this.cb_RowNames.setEnabled(enabled && this.tableModel.getColumnCount() > 1);
        this.rowNamesColumnIndex.setEnabled(this.cb_RowNames.isSelected());
        this.variablename.setEditable(enabled);
        this.variablename.setEnabled(enabled);
        if (enabled) {
            this.updateEnds = false;
            this.colEnd.setValue(this.tableModel.getColEnd() + 1);
            if (this.tableModel.hasRowNames()) {
                ((SpinnerNumberModel)this.colEnd.getModel()).setMaximum(Integer.valueOf(this.tableModel.getMaxColumnCount() - 1));
            } else {
                ((SpinnerNumberModel)this.colEnd.getModel()).setMaximum(Integer.valueOf(this.tableModel.getMaxColumnCount()));
            }
            ((SpinnerNumberModel)this.rowsEnd.getModel()).setMaximum(Integer.valueOf(this.tableModel.getMaxRowCount()));
            this.updateEnds = true;
        }
        this.configPanelEnabled = enabled;
    }

    public void resetTableModel() {
        this.tableModel = new ImportTableModel();
        this.tableModel.addPropertyChangeListener(new TableModelPropertyChangeListener());
        this.table.setModel((TableModel)this.tableModel);
    }

    public void resetRowAndColumnsMaxAndMin() {
        ((SpinnerNumberModel)this.colStart.getModel()).setMinimum(Integer.valueOf(1));
        ((SpinnerNumberModel)this.colEnd.getModel()).setMaximum(null);
        ((SpinnerNumberModel)this.rowsStart.getModel()).setMinimum(Integer.valueOf(1));
        ((SpinnerNumberModel)this.rowsEnd.getModel()).setMaximum(null);
    }

    private void initComponents() {
        this.delimiterButtonGroup = new ButtonGroup();
        this.quoteButtonGroup = new ButtonGroup();
        this.table = new ARCTableEx();
        this.configurationPanel = new JPanel();
        this.jLabel7 = new JLabel();
        this.tf_OtherDelimiter = new JTextField();
        this.rb_Semicolon = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.rb_OtherDelimiter = new JRadioButton();
        this.rb_Tab = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.rb_Comma = new JRadioButton();
        this.rb_DoubleQuote = new JRadioButton();
        this.rb_SingleQuote = new JRadioButton();
        this.rb_NoQuote = new JRadioButton();
        this.rb_Space = new JRadioButton();
        this.rb_OtherQuote = new JRadioButton();
        this.tf_otherQuote = new JTextField();
        this.rb_NoDelimiter = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.cb_ColumnNames = new JCheckBox();
        this.rowNamesColumnIndex = new JSpinner();
        this.cb_RowNames = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.colEnd = new JSpinner();
        this.jLabel4 = new JLabel();
        this.rowsEnd = new JSpinner();
        this.jLabel6 = new JLabel();
        this.rowsStart = new JSpinner();
        this.jLabel1 = new JLabel();
        this.colStart = new JSpinner();
        this.colNamesRowIndex = new JSpinner();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel9 = new JLabel();
        this.variablename = new JTextField();
        this.table.setHorizontalScrollEnabled(true);
        this.table.setMinimumSize(new Dimension(120, 49));
        this.table.setModel((TableModel)this.tableModel);
        this.table.setPreferredSize(new Dimension(250, 78));
        this.jLabel7.setText("Separator");
        this.tf_OtherDelimiter.setEditable(false);
        this.tf_OtherDelimiter.setEnabled(false);
        this.tf_OtherDelimiter.setDocument(new DelimiterDocument());
        this.delimiterButtonGroup.add(this.rb_Semicolon);
        this.rb_Semicolon.setText("semicolon (;)");
        this.rb_Semicolon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.rb_SemicolonActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Configuration");
        this.delimiterButtonGroup.add(this.rb_OtherDelimiter);
        this.rb_OtherDelimiter.setText("other");
        this.rb_OtherDelimiter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DataImportPanel.this.rb_OtherDelimiterItemStateChanged(evt);
            }
        });
        this.delimiterButtonGroup.add(this.rb_Tab);
        this.rb_Tab.setText("tab (\\t)");
        this.rb_Tab.setName("TAB");
        this.rb_Tab.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.rb_TabActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Quote");
        this.delimiterButtonGroup.add(this.rb_Comma);
        this.rb_Comma.setText("comma (,)");
        this.rb_Comma.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.rb_CommaActionPerformed(evt);
            }
        });
        this.quoteButtonGroup.add(this.rb_DoubleQuote);
        this.rb_DoubleQuote.setText("double quote (\")");
        this.rb_DoubleQuote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.rb_DoubleQuoteActionPerformed(evt);
            }
        });
        this.quoteButtonGroup.add(this.rb_SingleQuote);
        this.rb_SingleQuote.setText("single quote (')");
        this.rb_SingleQuote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.rb_SingleQuoteActionPerformed(evt);
            }
        });
        this.quoteButtonGroup.add(this.rb_NoQuote);
        this.rb_NoQuote.setText("none");
        this.rb_NoQuote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.rb_NoQuoteActionPerformed(evt);
            }
        });
        this.delimiterButtonGroup.add(this.rb_Space);
        this.rb_Space.setText("space ( )");
        this.rb_Space.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.rb_SpaceActionPerformed(evt);
            }
        });
        this.quoteButtonGroup.add(this.rb_OtherQuote);
        this.rb_OtherQuote.setText("other");
        this.rb_OtherQuote.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DataImportPanel.this.rb_OtherQuoteItemStateChanged(evt);
            }
        });
        this.tf_otherQuote.setEditable(false);
        this.tf_otherQuote.setDocument(new QuoteDocument());
        this.delimiterButtonGroup.add(this.rb_NoDelimiter);
        this.rb_NoDelimiter.setText("none");
        this.rb_NoDelimiter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.rb_NoDelimiterActionPerformed(evt);
            }
        });
        GroupLayout configurationPanelLayout = new GroupLayout(this.configurationPanel);
        this.configurationPanel.setLayout(configurationPanelLayout);
        configurationPanelLayout.setHorizontalGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(configurationPanelLayout.createSequentialGroup().addGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configurationPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel7)).addGroup(configurationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rb_Tab).addComponent(this.rb_DoubleQuote)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rb_SingleQuote).addComponent(this.rb_Semicolon)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rb_Comma).addComponent(this.rb_NoQuote)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configurationPanelLayout.createSequentialGroup().addComponent(this.rb_Space).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rb_NoDelimiter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rb_OtherDelimiter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tf_OtherDelimiter, -2, 48, -2)).addGroup(configurationPanelLayout.createSequentialGroup().addComponent(this.rb_OtherQuote).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tf_otherQuote, -2, 46, -2)))));
        configurationPanelLayout.setVerticalGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configurationPanelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.rb_Tab).addComponent(this.rb_Semicolon).addComponent(this.rb_Comma).addComponent(this.rb_Space).addComponent(this.rb_OtherDelimiter).addComponent(this.tf_OtherDelimiter, -2, -1, -2).addComponent(this.rb_NoDelimiter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(configurationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.rb_DoubleQuote).addComponent(this.rb_SingleQuote).addComponent(this.rb_NoQuote).addComponent(this.rb_OtherQuote).addComponent(this.tf_otherQuote, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel2.setText("Rows: from");
        this.cb_ColumnNames.setText("Use row");
        this.cb_ColumnNames.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DataImportPanel.this.cb_ColumnNamesItemStateChanged(evt);
            }
        });
        this.cb_ColumnNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.cb_ColumnNamesActionPerformed(evt);
            }
        });
        this.rowNamesColumnIndex.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.rowNamesColumnIndex.setEnabled(false);
        this.rowNamesColumnIndex.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DataImportPanel.this.rowNamesColumnIndexStateChanged(evt);
            }
        });
        this.cb_RowNames.setText("Use column");
        this.cb_RowNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataImportPanel.this.cb_RowNamesActionPerformed(evt);
            }
        });
        this.jLabel3.setText("to");
        this.colEnd.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.colEnd.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DataImportPanel.this.colEndStateChanged(evt);
            }
        });
        this.jLabel4.setText("to");
        this.rowsEnd.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.rowsEnd.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DataImportPanel.this.rowsEndStateChanged(evt);
            }
        });
        this.jLabel6.setText("Columns: from");
        this.rowsStart.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.rowsStart.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DataImportPanel.this.rowsStartStateChanged(evt);
            }
        });
        this.jLabel1.setText("Data range");
        this.colStart.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.colStart.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DataImportPanel.this.colStartStateChanged(evt);
            }
        });
        this.colNamesRowIndex.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.colNamesRowIndex.setEnabled(false);
        this.colNamesRowIndex.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DataImportPanel.this.colNamesRowIndexStateChanged(evt);
            }
        });
        this.jLabel10.setText("for col.names");
        this.jLabel11.setText("for row.names");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.colStart).addComponent(this.rowsStart, -1, 88, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowsEnd, -2, 91, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colEnd, -2, 91, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cb_ColumnNames).addComponent(this.cb_RowNames)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rowNamesColumnIndex).addComponent(this.colNamesRowIndex, -1, 74, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel10))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rowsStart, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.rowsEnd, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.colNamesRowIndex, -2, -1, -2).addComponent(this.cb_ColumnNames).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colStart, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.colEnd, -2, -1, -2).addComponent(this.jLabel6))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rowNamesColumnIndex, -2, -1, -2).addComponent(this.cb_RowNames).addComponent(this.jLabel11)));
        this.jLabel9.setText("Set Dataframe variable name");
        this.variablename.setText("temp");
        this.variablename.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                DataImportPanel.this.firePropertyChange(DataImportPanel.PROP_VARIABLENAME, null, null);
                DataImportPanel.this.useractionlistener.variableNameChanged(DataImportPanel.this.variablename.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                DataImportPanel.this.firePropertyChange(DataImportPanel.PROP_VARIABLENAME, null, null);
                DataImportPanel.this.useractionlistener.variableNameChanged(DataImportPanel.this.variablename.getText());
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.variablename, -2, 129, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.configurationPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent((Component)this.table, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.configurationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.variablename, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.table, -1, 308, Short.MAX_VALUE)));
    }

    private void cb_RowNamesActionPerformed(ActionEvent evt) {
        this.rowNamesColumnIndex.setEnabled(this.cb_RowNames.isSelected());
        ((SpinnerNumberModel)this.rowNamesColumnIndex.getModel()).setMaximum(Integer.valueOf(this.tableModel.getColumnCount()));
        this.tableModel.setHasRowNames(this.cb_RowNames.isSelected());
        if (this.configPanelEnabled) {
            this.useractionlistener.hasRowNamesChanged(this.cb_RowNames.isSelected());
        }
    }

    private void cb_ColumnNamesActionPerformed(ActionEvent evt) {
        this.tableModel.setHasColumnNames(this.cb_ColumnNames.isSelected());
        if (this.configPanelEnabled) {
            this.useractionlistener.hasColumnNamesChanged(this.cb_ColumnNames.isSelected());
        }
    }

    private void rowsStartStateChanged(ChangeEvent evt) {
        Integer newvalue = (Integer)this.rowsStart.getValue();
        if (newvalue <= (Integer)this.rowsEnd.getValue()) {
            this.tableModel.setRowStart(newvalue - 1);
            if (this.configPanelEnabled) {
                this.useractionlistener.rowStartChanged(newvalue);
            }
        } else {
            this.rowsStart.setValue(this.rowsStart.getPreviousValue());
        }
    }

    private void rowsEndStateChanged(ChangeEvent evt) {
        int newvalue = (Integer)this.rowsEnd.getValue();
        if (newvalue >= (Integer)this.rowsStart.getValue()) {
            this.tableModel.setRowEnd(newvalue - 1);
            if (this.updateEnds && this.configPanelEnabled) {
                this.useractionlistener.rowEndChange(newvalue);
            }
        } else {
            this.rowsEnd.setValue(this.rowsEnd.getPreviousValue());
        }
    }

    private void colStartStateChanged(ChangeEvent evt) {
        Integer newvalue = (Integer)this.colStart.getValue();
        if (newvalue <= (Integer)this.colEnd.getValue()) {
            this.tableModel.setColStart(newvalue - 1);
            this.useractionlistener.colStartChanged(newvalue);
        } else {
            this.colStart.setValue(this.colStart.getPreviousValue());
        }
        ((SpinnerNumberModel)this.rowNamesColumnIndex.getModel()).setMaximum(Integer.valueOf(this.tableModel.getColumnCount()));
    }

    private void colEndStateChanged(ChangeEvent evt) {
        int newvalue = (Integer)this.colEnd.getValue();
        if (newvalue >= (Integer)this.colStart.getValue()) {
            this.tableModel.setColEnd(newvalue - 1);
            if (this.updateEnds && this.configPanelEnabled) {
                this.useractionlistener.colEndChange(newvalue);
            }
        } else {
            this.colEnd.setValue(this.colEnd.getPreviousValue());
        }
        if (newvalue == 1 && !this.cb_RowNames.isSelected()) {
            this.cb_RowNames.setEnabled(false);
        } else {
            this.cb_RowNames.setEnabled(true);
        }
        ((SpinnerNumberModel)this.rowNamesColumnIndex.getModel()).setMaximum(Integer.valueOf(this.tableModel.getColumnCount()));
    }

    private void rb_NoQuoteActionPerformed(ActionEvent evt) {
        if (this.configPanelEnabled) {
            this.useractionlistener.quoteChanged(null);
        }
        this.firePropertyChange(PROP_QUALIFIER, null, null);
    }

    private void rb_DoubleQuoteActionPerformed(ActionEvent evt) {
        if (this.configPanelEnabled) {
            this.useractionlistener.quoteChanged("\\\"");
        }
        this.firePropertyChange(PROP_QUALIFIER, null, Character.valueOf('\"'));
    }

    private void rb_SingleQuoteActionPerformed(ActionEvent evt) {
        if (this.configPanelEnabled) {
            this.useractionlistener.quoteChanged("'");
        }
        this.firePropertyChange(PROP_QUALIFIER, null, Character.valueOf('\''));
    }

    private void rb_SemicolonActionPerformed(ActionEvent evt) {
        if (this.configPanelEnabled) {
            this.useractionlistener.separatorChanged(";");
        }
        this.firePropertyChange(PROP_DELIMITER, null, Character.valueOf(';'));
    }

    private void rb_TabActionPerformed(ActionEvent evt) {
        if (this.configPanelEnabled) {
            this.useractionlistener.separatorChanged("\\t");
        }
        this.firePropertyChange(PROP_DELIMITER, null, Character.valueOf('\t'));
    }

    private void rb_SpaceActionPerformed(ActionEvent evt) {
        if (this.configPanelEnabled) {
            this.useractionlistener.separatorChanged(" ");
        }
        this.firePropertyChange(PROP_DELIMITER, null, Character.valueOf(' '));
    }

    private void rb_CommaActionPerformed(ActionEvent evt) {
        if (this.configPanelEnabled) {
            this.useractionlistener.separatorChanged(",");
        }
        this.firePropertyChange(PROP_DELIMITER, null, Character.valueOf(','));
    }

    private void rowNamesColumnIndexStateChanged(ChangeEvent evt) {
        int newvalue = (Integer)this.rowNamesColumnIndex.getValue();
        if (newvalue - 1 != this.tableModel.getRownamesColumnIndex()) {
            this.tableModel.setRowNamesColumnIndex(newvalue - 1);
            if (this.configPanelEnabled) {
                this.useractionlistener.rowNamesNoChanged(newvalue);
            }
        }
    }

    private void cb_ColumnNamesItemStateChanged(ItemEvent evt) {
        this.colNamesRowIndex.setEnabled(this.cb_ColumnNames.isSelected());
    }

    private void colNamesRowIndexStateChanged(ChangeEvent evt) {
        int newvalue = (Integer)this.colNamesRowIndex.getValue();
        this.tableModel.setColumnNamesRowIndex(newvalue - 1);
        ((SpinnerNumberModel)this.rowsStart.getModel()).setMinimum(Integer.valueOf(newvalue + 1));
        if (this.configPanelEnabled) {
            this.useractionlistener.columnNamesRowIndexChanged(newvalue);
        }
    }

    private void rb_OtherDelimiterItemStateChanged(ItemEvent evt) {
        this.tf_OtherDelimiter.setEditable(this.rb_OtherDelimiter.isSelected());
        this.tf_OtherDelimiter.setEnabled(this.rb_OtherDelimiter.isSelected());
    }

    private void rb_OtherQuoteItemStateChanged(ItemEvent evt) {
        this.tf_otherQuote.setEditable(this.rb_OtherQuote.isSelected());
        this.tf_otherQuote.setEnabled(this.rb_OtherQuote.isSelected());
    }

    private void rb_NoDelimiterActionPerformed(ActionEvent evt) {
        if (this.configPanelEnabled) {
            this.useractionlistener.separatorChanged(null);
        }
        this.firePropertyChange(PROP_DELIMITER, null, null);
    }

    public void setDelimiter(char delimiter) {
        if (delimiter == ',') {
            this.rb_Comma.setSelected(true);
        } else if (delimiter == ';') {
            this.rb_Semicolon.setSelected(true);
        } else if (delimiter == '\t') {
            this.rb_Tab.setSelected(true);
        } else if (delimiter == ' ') {
            this.rb_Space.setSelected(true);
        } else if (delimiter == '\u0000') {
            this.rb_NoDelimiter.setSelected(true);
        } else if (!this.tf_OtherDelimiter.getText().equals("" + delimiter)) {
            this.tf_OtherDelimiter.setText("" + delimiter);
        }
        if (this.configPanelEnabled) {
            if (delimiter == '\t') {
                this.useractionlistener.separatorChanged("\\t");
            } else {
                this.useractionlistener.separatorChanged("" + delimiter);
            }
        }
    }

    public void setQualifer(char qualifer) {
        String s_qualifier = null;
        if (qualifer == '\"') {
            this.rb_DoubleQuote.setSelected(true);
            s_qualifier = "\\\"";
        } else if (qualifer == '\'') {
            this.rb_SingleQuote.setSelected(true);
            s_qualifier = "" + qualifer;
        } else if (qualifer == '\u0000') {
            this.rb_NoQuote.setSelected(true);
        } else if (!this.tf_otherQuote.getText().equals("" + qualifer)) {
            this.tf_otherQuote.setText("" + qualifer);
        }
        if (this.configPanelEnabled) {
            this.useractionlistener.quoteChanged(s_qualifier);
        }
    }

    public String getVariableName() {
        return this.variablename.getText();
    }

    public void setUseractionlistener(DataImportPanelUserActionListener useractionlistener) {
        this.useractionlistener = useractionlistener;
    }

    public void setFilterListener(FilterListener listener) {
        this.table.addFilterListener(listener);
    }

    private class ARCTableEx
    extends ARCTable {
        public ARCTableEx() {
            this.adjustVisualAppearance();
        }

        private void adjustVisualAppearance() {
            this.filterScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.inputSelectorScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.tableScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.table.setIntercellSpacing(new Dimension(10, 1));
        }
    }

    private class DummyUserActionListener
    implements DataImportPanelUserActionListener {
        private DummyUserActionListener() {
        }

        public void separatorChanged(String newvalue) {
        }

        public void quoteChanged(String newvalue) {
        }

        public void rowStartChanged(int newvalue) {
        }

        public void rowEndChange(int newvalue) {
        }

        public void colStartChanged(int newvalue) {
        }

        public void colEndChange(int newvalue) {
        }

        public void hasColumnNamesChanged(Boolean newvalue) {
        }

        public void hasRowNamesChanged(Boolean newvalue) {
        }

        public void rowNamesNoChanged(int newvalue) {
            System.out.println("ss");
        }

        public void variableNameChanged(String newvalue) {
        }

        public void columnNamesRowIndexChanged(int newvalue) {
        }

        public void tableCellValueChanged(Object aValue, int rowIndex, int columnIndex) {
        }

        public void colClassesChanged(String[] classes) {
        }

        public void colClassChanged(int columnIndex, String clazz) {
        }
    }

    private class QuoteDocument
    extends PlainDocument {
        private QuoteDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                super.insertString(0, str, a);
                return;
            }
            if (this.getLength() > 0) {
                super.remove(0, 1);
            }
            if (str.length() > 0) {
                str = "" + str.charAt(0);
            }
            super.insertString(0, str, a);
            DataImportPanel.this.firePropertyChange(DataImportPanel.PROP_QUALIFIER, null, Character.valueOf(str.charAt(0)));
            DataImportPanel.this.useractionlistener.quoteChanged(str);
        }
    }

    private class DelimiterDocument
    extends PlainDocument {
        private DelimiterDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.getLength() > 0) {
                super.remove(0, 1);
            }
            if (this.getLength() > 0) {
                str = "" + str.charAt(0);
            }
            super.insertString(0, str, a);
            DataImportPanel.this.firePropertyChange(DataImportPanel.PROP_DELIMITER, null, Character.valueOf(str.charAt(0)));
            DataImportPanel.this.useractionlistener.separatorChanged(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnTypeListener
    implements ColumnSelectorListener<ColumnType> {
        private String[] colClasses;
        private boolean canceled = false;

        private ColumnTypeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void columnSelectionChanged(ColumnSelectorEvent<ColumnType> evt) throws ColumnSelectorVetoException {
            DataImportPanel.this.table.removeColumnSelectorListener((ColumnSelectorListener)this);
            this.canceled = false;
            try {
                if (evt.getColumn() == -1) {
                    if (DataImportPanel.this.tableModel.getColumnCount() > 0) {
                        if (this.colClasses == null || this.colClasses.length != DataImportPanel.this.tableModel.getColumnCount()) {
                            this.colClasses = new String[DataImportPanel.this.tableModel.getColumnCount()];
                        }
                        for (int i = 0; i < DataImportPanel.this.tableModel.getColumnCount(); ++i) {
                            if (DataImportPanel.this.tableModel.getColumnClass(i) == Double.class) {
                                DataImportPanel.this.table.setColumnSelectorOption((Object)ColumnType.NUMERIC, i);
                                this.colClasses[i] = ColumnType.NUMERIC.toString().toLowerCase();
                                continue;
                            }
                            if (DataImportPanel.this.tableModel.getColumnClass(i) == String.class) {
                                DataImportPanel.this.table.setColumnSelectorOption((Object)ColumnType.CHARACTER, i);
                                this.colClasses[i] = ColumnType.CHARACTER.toString().toLowerCase();
                                continue;
                            }
                            if (DataImportPanel.this.tableModel.getColumnClass(i) == RDate.class) {
                                DataImportPanel.this.table.setColumnSelectorOption((Object)ColumnType.DATE, i);
                                this.colClasses[i] = ColumnType.DATE.toString();
                                continue;
                            }
                            if (DataImportPanel.this.tableModel.getColumnClass(i) != RPOSIXct.class) continue;
                            DataImportPanel.this.table.setColumnSelectorOption((Object)ColumnType.POSIXCT, i);
                            this.colClasses[i] = ColumnType.POSIXCT.toString();
                        }
                    }
                } else if (evt.getNewValue().getObject() == ColumnType.CHARACTER) {
                    if (evt.getOldValue().getObject() != ColumnType.FACTOR) {
                        this.convertToText(evt);
                    }
                    this.colClasses[evt.getColumn()] = ColumnType.CHARACTER.toString().toLowerCase();
                    DataImportPanel.this.useractionlistener.colClassChanged(evt.getColumn(), this.colClasses[evt.getColumn()]);
                    this.callColClassesChanged();
                } else if (evt.getNewValue().getObject() == ColumnType.FACTOR) {
                    if (evt.getOldValue().getObject() != ColumnType.CHARACTER) {
                        this.convertToText(evt);
                    }
                    this.colClasses[evt.getColumn()] = ColumnType.FACTOR.toString().toLowerCase();
                    DataImportPanel.this.useractionlistener.colClassChanged(evt.getColumn(), this.colClasses[evt.getColumn()]);
                    this.callColClassesChanged();
                } else if (evt.getNewValue().getObject() == ColumnType.NUMERIC) {
                    this.convertToNumeric(evt);
                    DataImportPanel.this.useractionlistener.colClassChanged(evt.getColumn(), this.colClasses[evt.getColumn()]);
                } else if (evt.getNewValue().getObject() == ColumnType.DATE) {
                    this.convertToDate(evt);
                    DataImportPanel.this.useractionlistener.colClassChanged(evt.getColumn(), this.colClasses[evt.getColumn()]);
                } else if (evt.getNewValue().getObject() == ColumnType.POSIXCT) {
                    this.convertToPOSIXct(evt);
                    DataImportPanel.this.useractionlistener.colClassChanged(evt.getColumn(), this.colClasses[evt.getColumn()]);
                }
            }
            finally {
                DataImportPanel.this.table.addColumnSelectorListener((ColumnSelectorListener)this);
            }
        }

        private void convertToText(final ColumnSelectorEvent<ColumnType> evt) throws ColumnSelectorVetoException {
            final JDialog dialog = new JDialog((Frame)((JFrame)DataImportPanel.this.getTopLevelAncestor()), true);
            SwingWorker<List<String>, Object> worker = new SwingWorker<List<String>, Object>(){

                @Override
                protected List<String> doInBackground() throws Exception {
                    return DataImportPanel.this.tableModelHelper.getColumnData(evt.getColumn());
                }

                @Override
                protected void done() {
                    dialog.setVisible(false);
                }
            };
            worker.execute();
            try {
                worker.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                JPanel p = new JPanel((LayoutManager)new MigLayout("align center,fillx", "[250]10[]", "[80]"));
                JProgressBar pb = new JProgressBar();
                pb.setIndeterminate(true);
                pb.setString("Rereading the column. Please wait...");
                pb.setStringPainted(true);
                p.add(pb);
                JButton jb = new JButton("Cancel");
                jb.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ColumnTypeListener.this.canceled = true;
                        dialog.setVisible(false);
                    }
                });
                p.add(jb);
                dialog.setContentPane(p);
                dialog.setSize(p.getPreferredSize());
                dialog.setLocationRelativeTo(DataImportPanel.this);
                dialog.setVisible(true);
            }
            catch (Exception ex) {
                throw new ColumnSelectorVetoException((Throwable)ex);
            }
            try {
                if (!this.canceled) {
                    DataImportPanel.this.tableModel.convertToText(evt.getColumn(), (List)worker.get());
                }
            }
            catch (Exception ex) {
                throw new ColumnSelectorVetoException((Throwable)ex);
            }
        }

        private void convertToNumeric(ColumnSelectorEvent<ColumnType> evt) throws ColumnSelectorVetoException {
            try {
                DataImportPanel.this.tableModel.convertToNumeric(evt.getColumn());
                this.colClasses[evt.getColumn()] = ColumnType.NUMERIC.toString().toLowerCase();
                this.callColClassesChanged();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(DataImportPanel.this, ex.getMessage());
                throw new ColumnSelectorVetoException((Throwable)ex);
            }
        }

        private void convertToDate(ColumnSelectorEvent<ColumnType> evt) throws ColumnSelectorVetoException {
            try {
                DataImportPanel.this.tableModel.convertToDate(evt.getColumn(), RUtil.parseDatePattern);
                this.colClasses[evt.getColumn()] = ColumnType.DATE.toString();
                this.callColClassesChanged();
            }
            catch (Exception ex) {
                StringBuilder errmsg = new StringBuilder("Could not parse to Date using the following formats:\n");
                for (String rformat : RUtil.parseDatePatternInRFormat) {
                    errmsg.append(rformat).append('\n');
                }
                errmsg.append(ex.getMessage()).append("\n Would you like to set the Date pattern below (system default proposed) and try again?");
                String pattern = (String)JOptionPane.showInputDialog(DataImportPanel.this, errmsg, "Date Format", 3, null, null, RUtil.defaultDatePatternInRFormat);
                if (pattern != null && pattern.length() > 0) {
                    try {
                        DataImportPanel.this.tableModel.convertToDate(evt.getColumn(), new String[]{RUtil.convertPatternFromRFormat(pattern)});
                        this.colClasses[evt.getColumn()] = ColumnType.DATE.toString() + "=" + pattern;
                        this.callColClassesChanged();
                    }
                    catch (Exception ex1) {
                        errmsg = new StringBuilder("Could not parse to Date using the following format:\n").append(pattern).append('\n').append(ex1.getMessage());
                        JOptionPane.showMessageDialog(DataImportPanel.this, errmsg);
                        throw new ColumnSelectorVetoException((Throwable)ex1);
                    }
                }
                throw new ColumnSelectorVetoException((Throwable)ex);
            }
        }

        private void convertToPOSIXct(ColumnSelectorEvent<ColumnType> evt) throws ColumnSelectorVetoException {
            try {
                DataImportPanel.this.tableModel.convertToPOSIXct(evt.getColumn(), RUtil.parsePOSIXctPattern);
                this.colClasses[evt.getColumn()] = ColumnType.POSIXCT.toString();
                this.callColClassesChanged();
            }
            catch (Exception ex) {
                StringBuilder errmsg = new StringBuilder("Could not parse to POSIXct using the following formats:\n");
                for (String rformat : RUtil.parsePOSIXctPatternInRFormat) {
                    errmsg.append(rformat).append('\n');
                }
                errmsg.append(ex.getMessage()).append("\n Would you like to set the Date pattern below (system default proposed) and try again?");
                String pattern = (String)JOptionPane.showInputDialog(DataImportPanel.this, errmsg, "POSIXct Format", 3, null, null, RUtil.defaultPOSIXctPatternInRFormat);
                if (pattern != null && pattern.length() > 0) {
                    try {
                        DataImportPanel.this.tableModel.convertToPOSIXct(evt.getColumn(), new String[]{RUtil.convertPatternFromRFormat(pattern)});
                        this.colClasses[evt.getColumn()] = ColumnType.POSIXCT.toString() + "=" + pattern;
                        this.callColClassesChanged();
                    }
                    catch (Exception ex1) {
                        errmsg = new StringBuilder("Could not parse to POSIXct using the following format:\n").append(pattern).append('\n').append(ex1.getMessage());
                        JOptionPane.showMessageDialog(DataImportPanel.this, errmsg);
                        throw new ColumnSelectorVetoException((Throwable)ex1);
                    }
                }
                throw new ColumnSelectorVetoException((Throwable)ex);
            }
        }

        private void callColClassesChanged() {
            if (DataImportPanel.this.tableModel.hasRowNames()) {
                DataImportPanel.this.useractionlistener.colClassesChanged(Arrays.copyOfRange(this.colClasses, 1, this.colClasses.length));
            } else {
                DataImportPanel.this.useractionlistener.colClassesChanged(this.colClasses);
            }
        }
    }

    private class TableModelPropertyChangeListener
    implements PropertyChangeListener {
        private TableModelPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == ImportTableModel.PROP.HASCOLUMNNAMES.name()) {
                Boolean newValue;
                Boolean oldValue = DataImportPanel.this.cb_ColumnNames.isSelected();
                if (oldValue != (newValue = (Boolean)evt.getNewValue())) {
                    DataImportPanel.this.cb_ColumnNames.setSelected(newValue);
                }
                if (newValue.booleanValue()) {
                    ((SpinnerNumberModel)DataImportPanel.this.rowsStart.getModel()).setMinimum(Integer.valueOf(DataImportPanel.this.tableModel.getColumnNamesRowIndex() + 2));
                } else {
                    ((SpinnerNumberModel)DataImportPanel.this.rowsStart.getModel()).setMinimum(Integer.valueOf(1));
                }
                if (DataImportPanel.this.configPanelEnabled) {
                    DataImportPanel.this.useractionlistener.hasColumnNamesChanged(newValue);
                }
            } else if (evt.getPropertyName() == ImportTableModel.PROP.COLUMNNAMESROWINDEX.name()) {
                Integer newValue;
                Integer oldValue = (Integer)DataImportPanel.this.colNamesRowIndex.getValue();
                if (oldValue != (newValue = Integer.valueOf(DataImportPanel.this.tableModel.getColumnNamesRowIndex() + 1))) {
                    DataImportPanel.this.colNamesRowIndex.setValue(newValue);
                }
            } else if (evt.getPropertyName() == ImportTableModel.PROP.RANGE_ROWSTART.name()) {
                Integer oldValue = (Integer)DataImportPanel.this.rowsStart.getValue();
                Integer newValue = (Integer)evt.getNewValue() + 1;
                if (oldValue > newValue) {
                    DataImportPanel.this.table.removeColumnSelectorListener((ColumnSelectorListener)DataImportPanel.this.columnDataTypeListener);
                    for (int columnIndex = 0; columnIndex < DataImportPanel.this.tableModel.getColumnCount(); ++columnIndex) {
                        if (DataImportPanel.this.tableModel.getColumnClass(columnIndex) != Double.class || !DataImportPanel.this.tableModel.containsNonNumeric(columnIndex)) continue;
                        try {
                            DataImportPanel.this.table.setColumnSelectorOption((Object)ColumnType.CHARACTER, columnIndex);
                            DataImportPanel.this.columnDataTypeListener.convertToText((ColumnSelectorEvent<ColumnType>)new ColumnSelectorEvent(columnIndex, null, null));
                            continue;
                        }
                        catch (ColumnSelectorVetoException ex) {
                            Logger.getLogger(DataImportPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    DataImportPanel.this.table.addColumnSelectorListener((ColumnSelectorListener)DataImportPanel.this.columnDataTypeListener);
                }
                if (oldValue != newValue) {
                    DataImportPanel.this.rowsStart.setValue(newValue);
                }
                if (DataImportPanel.this.configPanelEnabled) {
                    DataImportPanel.this.useractionlistener.rowStartChanged(newValue);
                }
            } else if (evt.getPropertyName() == ImportTableModel.PROP.RANGE_ROWEND.name()) {
                Integer newValue;
                Integer oldValue = (Integer)DataImportPanel.this.rowsEnd.getValue();
                if (oldValue != (newValue = Integer.valueOf((Integer)evt.getNewValue() + 1))) {
                    DataImportPanel.this.updateEnds = false;
                    DataImportPanel.this.rowsEnd.setValue(newValue);
                    DataImportPanel.this.updateEnds = true;
                }
            } else if (evt.getPropertyName() == ImportTableModel.PROP.RANGE_COLSTART.name()) {
                Integer newValue;
                Integer oldValue = (Integer)DataImportPanel.this.colStart.getValue();
                if (oldValue != (newValue = Integer.valueOf((Integer)evt.getNewValue() + 1))) {
                    DataImportPanel.this.colStart.setValue(newValue);
                }
                DataImportPanel.this.useractionlistener.colStartChanged(newValue);
            } else if (evt.getPropertyName() == ImportTableModel.PROP.RANGE_COLEND.name()) {
                Integer newValue;
                Integer oldValue = (Integer)DataImportPanel.this.colEnd.getValue();
                if (oldValue != (newValue = Integer.valueOf((Integer)evt.getNewValue() + 1))) {
                    DataImportPanel.this.updateEnds = false;
                    DataImportPanel.this.colEnd.setValue(newValue);
                    DataImportPanel.this.updateEnds = true;
                }
            } else if (evt.getPropertyName() == ImportTableModel.PROP.HASROWNAMES.name()) {
                if (Boolean.valueOf(DataImportPanel.this.cb_RowNames.isSelected()) != evt.getNewValue()) {
                    DataImportPanel.this.cb_RowNames.setSelected((Boolean)evt.getNewValue());
                }
                if (DataImportPanel.this.tableModel.hasRowNames()) {
                    ((SpinnerNumberModel)DataImportPanel.this.colEnd.getModel()).setMaximum(Integer.valueOf(DataImportPanel.this.tableModel.getMaxColumnCount() - 1));
                    DataImportPanel.this.table.removeColumnSelectorListener((ColumnSelectorListener)DataImportPanel.this.columnDataTypeListener);
                    try {
                        DataImportPanel.this.table.setColumnSelectorOption((Object)ColumnType.CHARACTER, 0);
                        DataImportPanel.this.columnDataTypeListener.convertToText((ColumnSelectorEvent<ColumnType>)new ColumnSelectorEvent(0, null, null));
                        DataImportPanel.this.table.setColumnSelectorEnabled(0, false);
                    }
                    catch (ColumnSelectorVetoException ex) {
                        Logger.getLogger(DataImportPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    DataImportPanel.this.table.addColumnSelectorListener((ColumnSelectorListener)DataImportPanel.this.columnDataTypeListener);
                } else {
                    ((SpinnerNumberModel)DataImportPanel.this.colEnd.getModel()).setMaximum(Integer.valueOf(DataImportPanel.this.tableModel.getMaxColumnCount()));
                    DataImportPanel.this.table.setColumnSelectorEnabled(0, true);
                }
                if (DataImportPanel.this.configPanelEnabled) {
                    DataImportPanel.this.useractionlistener.hasRowNamesChanged((Boolean)evt.getNewValue());
                }
            } else if (evt.getPropertyName() == ImportTableModel.PROP.ROWNAMESCOLUMNINDEX.name()) {
                Integer newValue;
                Integer oldValue = (Integer)DataImportPanel.this.rowNamesColumnIndex.getValue();
                if (oldValue != (newValue = Integer.valueOf((Integer)evt.getNewValue() + 1))) {
                    DataImportPanel.this.rowNamesColumnIndex.setValue(newValue);
                }
                if (DataImportPanel.this.configPanelEnabled) {
                    DataImportPanel.this.useractionlistener.rowNamesNoChanged(newValue);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColumnType {
        NUMERIC("Numeric"),
        CHARACTER("Character"),
        FACTOR("Factor"),
        DATE("Date"),
        POSIXCT("POSIXct");

        private String displayname;

        private ColumnType(String displayname) {
            this.displayname = displayname;
        }

        public String toString() {
            return this.displayname;
        }
    }
}

