/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class BubbleDisplayer
extends BasicDockableDisplayer {
    private int borderSize = 2;
    private JPanel dockable;
    private BubbleColorAnimation animation;
    private DisplayerColor borderHighActive = new BubbleDisplayerColor("displayer.border.high.active", Color.WHITE);
    private DisplayerColor borderHighActiveMouse = new BubbleDisplayerColor("displayer.border.high.active.mouse", Color.WHITE);
    private DisplayerColor borderHighInactive = new BubbleDisplayerColor("displayer.border.high.inactive", Color.DARK_GRAY);
    private DisplayerColor borderHighInactiveMouse = new BubbleDisplayerColor("displayer.border.high.inactive.mouse", Color.DARK_GRAY);
    private DisplayerColor borderLowActive = new BubbleDisplayerColor("displayer.border.low.active", Color.LIGHT_GRAY);
    private DisplayerColor borderLowActiveMouse = new BubbleDisplayerColor("displayer.border.low.active.mouse", Color.LIGHT_GRAY);
    private DisplayerColor borderLowInactive = new BubbleDisplayerColor("displayer.border.low.inactive", Color.BLACK);
    private DisplayerColor borderLowInactiveMouse = new BubbleDisplayerColor("displayer.border.low.inactive.mouse", Color.BLACK);
    private boolean mouse = false;
    private Listener listener = new Listener();

    public BubbleDisplayer(DockStation dockStation, Dockable dockable, DockTitle dockTitle) {
        super(dockStation, dockable, dockTitle);
        this.animation = new BubbleColorAnimation();
        this.animation.addTask(new Runnable(){

            public void run() {
                BubbleDisplayer.this.pulse();
            }
        });
        this.updateAnimation();
        this.setRespectBorderHint(true);
        this.setDefaultBorderHint(true);
        this.setSingleTabShowInnerBorder(true);
        this.setSingleTabShowOuterBorder(false);
    }

    protected void updateAnimation() {
        if (this.animation != null) {
            DockController dockController = this.getController();
            if (dockController != null && dockController.getFocusedDockable() == this.getDockable()) {
                if (this.mouse) {
                    this.animation.putColor("high", (Color)this.borderHighActiveMouse.value());
                    this.animation.putColor("low", (Color)this.borderLowActiveMouse.value());
                } else {
                    this.animation.putColor("high", (Color)this.borderHighActive.value());
                    this.animation.putColor("low", (Color)this.borderLowActive.value());
                }
            } else if (this.mouse) {
                this.animation.putColor("high", (Color)this.borderHighInactiveMouse.value());
                this.animation.putColor("low", (Color)this.borderLowInactiveMouse.value());
            } else {
                this.animation.putColor("high", (Color)this.borderHighInactive.value());
                this.animation.putColor("low", (Color)this.borderLowInactive.value());
            }
        }
    }

    protected void pulse() {
        this.dockable.repaint();
    }

    public void setController(DockController dockController) {
        DockController dockController2 = this.getController();
        if (dockController2 != dockController) {
            if (dockController2 != null) {
                dockController2.removeDockableFocusListener(this.listener);
            }
            if (dockController != null) {
                dockController.addDockableFocusListener(this.listener);
            }
            super.setController(dockController);
        }
        this.borderHighActive.connect(dockController);
        this.borderHighActiveMouse.connect(dockController);
        this.borderHighInactive.connect(dockController);
        this.borderHighInactiveMouse.connect(dockController);
        this.borderLowActive.connect(dockController);
        this.borderLowActiveMouse.connect(dockController);
        this.borderLowInactive.connect(dockController);
        this.borderLowInactiveMouse.connect(dockController);
        this.animation.kick();
    }

    protected void addDockable(Dockable dockable, Component component) {
        if (component != null) {
            this.ensureDockable();
            this.dockable.add(component);
        }
    }

    protected void removeDockable(Dockable dockable, Component component) {
        if (component != null) {
            this.ensureDockable();
            this.dockable.remove(component);
        }
    }

    protected Component getComponent(Dockable dockable) {
        this.ensureDockable();
        return this.dockable;
    }

    public void setTitle(DockTitle dockTitle) {
        DockTitle dockTitle2 = this.getTitle();
        if (dockTitle2 != null) {
            dockTitle2.removeMouseInputListener(this.listener);
        }
        super.setTitle(dockTitle);
        if (dockTitle != null) {
            dockTitle.addMouseInputListener(this.listener);
        }
        this.mouse = false;
        this.updateAnimation();
        this.ensureDockable();
    }

    public void setDockable(Dockable dockable) {
        super.setDockable(dockable);
        this.ensureBorder();
    }

    private void ensureDockable() {
        if (this.dockable == null) {
            this.dockable = new JPanel(new GridLayout(1, 1));
            this.getContent().add(this.dockable);
        }
        this.ensureBorder();
    }

    private void ensureBorder() {
        if (this.dockable != null) {
            boolean bl;
            Dockable dockable = this.getDockable();
            boolean bl2 = bl = dockable != null && dockable.asDockStation() != null;
            if (this.getTitle() == null && bl) {
                this.setDefaultBorderHint(false);
            } else {
                this.setDefaultBorderHint(true);
            }
        }
    }

    protected void updateBorder() {
        if (this.isRespectBorderHint()) {
            if (this.getHints().getShowBorderHint() || this.getTitle() != null) {
                this.dockable.setBorder(this.getDefaultBorder());
            } else {
                this.dockable.setBorder(null);
            }
        }
    }

    protected Border getDefaultBorder() {
        return new OpenBorder();
    }

    public Insets getDockableInsets() {
        Insets insets = super.getDockableInsets();
        Border border = this.dockable.getBorder();
        if (border != null) {
            Insets insets2 = border.getBorderInsets(this.dockable);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    private class OpenBorder
    implements Border {
        private OpenBorder() {
        }

        public Insets getBorderInsets(Component component) {
            if (BubbleDisplayer.this.getTitle() == null) {
                return new Insets(BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize);
            }
            switch (BubbleDisplayer.this.getTitleLocation()) {
                case BOTTOM: {
                    return new Insets(BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, 0, BubbleDisplayer.this.borderSize);
                }
                case LEFT: {
                    return new Insets(BubbleDisplayer.this.borderSize, 0, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize);
                }
                case RIGHT: {
                    return new Insets(BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, 0);
                }
                case TOP: {
                    return new Insets(0, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize, BubbleDisplayer.this.borderSize);
                }
            }
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = BubbleDisplayer.this.animation.getColor("high");
            Color color2 = BubbleDisplayer.this.animation.getColor("low");
            boolean bl = BubbleDisplayer.this.getTitle() == null;
            boolean bl2 = bl || BubbleDisplayer.this.getTitleLocation() != DockableDisplayer.Location.TOP;
            boolean bl3 = bl || BubbleDisplayer.this.getTitleLocation() != DockableDisplayer.Location.LEFT;
            boolean bl4 = bl || BubbleDisplayer.this.getTitleLocation() != DockableDisplayer.Location.RIGHT;
            boolean bl5 = bl || BubbleDisplayer.this.getTitleLocation() != DockableDisplayer.Location.BOTTOM;
            int n5 = BubbleDisplayer.this.borderSize / 2;
            int n6 = BubbleDisplayer.this.borderSize - n5;
            if (bl2) {
                graphics.setColor(color);
                graphics.fillRect(n, n2, n3, n5);
                graphics.setColor(color2);
                graphics.fillRect(n, n2 + n5, n3, n6);
            }
            if (bl3) {
                graphics.setColor(color);
                graphics.fillRect(n, n2, n5, n4);
                graphics.setColor(color2);
                if (bl2) {
                    graphics.fillRect(n + n5, n2 + n5, n6, n4 - n5);
                } else {
                    graphics.fillRect(n + n5, n2, n6, n4);
                }
            }
            if (bl4) {
                graphics.setColor(color);
                graphics.fillRect(n + n3 - BubbleDisplayer.this.borderSize, n2, n5, n4);
                graphics.setColor(color2);
                if (bl2) {
                    graphics.fillRect(n + n3 - n6, n2 + n5, n6, n4 - n5);
                } else {
                    graphics.fillRect(n + n3 - n6, n2, n6, n4);
                }
            }
            if (bl5) {
                graphics.setColor(color);
                if (bl4) {
                    graphics.fillRect(n, n2 + n4 - BubbleDisplayer.this.borderSize, n3 - BubbleDisplayer.this.borderSize, n5);
                } else {
                    graphics.fillRect(n, n2 + n4 - BubbleDisplayer.this.borderSize, n3, n5);
                }
                graphics.setColor(color2);
                graphics.fillRect(n, n2 + n4 - n6, n3, n6);
            }
        }
    }

    private class BubbleDisplayerColor
    extends DisplayerColor {
        public BubbleDisplayerColor(String string, Color color) {
            super(string, BubbleDisplayer.this, color);
        }

        protected void changed(Color color, Color color2) {
            BubbleDisplayer.this.updateAnimation();
        }
    }

    private class Listener
    extends MouseInputAdapter
    implements DockableFocusListener {
        private Listener() {
        }

        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            BubbleDisplayer.this.updateAnimation();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BubbleDisplayer.this.mouse = true;
            BubbleDisplayer.this.updateAnimation();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BubbleDisplayer.this.mouse = false;
            BubbleDisplayer.this.updateAnimation();
        }
    }
}

