/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.EclipseDockTitleEvent;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.themes.basic.BasicDockTitle;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Condition;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;

public class BasicTabDockTitle
extends BasicDockTitle {
    private EclipseTheme theme;
    private boolean selected = false;
    private boolean paintIconWhenInactive = true;
    private TitleColor borderColor;

    public static DockTitleFactory createFactory(final EclipseTheme eclipseTheme) {
        return new DockTitleFactory(){

            public void install(DockTitleRequest dockTitleRequest) {
            }

            public void uninstall(DockTitleRequest dockTitleRequest) {
            }

            public void request(DockTitleRequest dockTitleRequest) {
                dockTitleRequest.answer(new BasicTabDockTitle(eclipseTheme, dockTitleRequest.getTarget(), dockTitleRequest.getVersion()));
            }
        };
    }

    public BasicTabDockTitle(EclipseTheme eclipseTheme, Dockable dockable, DockTitleVersion dockTitleVersion) {
        super(dockable, dockTitleVersion, false);
        this.theme = eclipseTheme;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.setActiveLeftColorId("stack.tab.top.selected.focused");
        this.setActiveRightColorId("stack.tab.bottom.selected.focused");
        this.setActiveTextColorId("stack.tab.text");
        this.setInactiveLeftColorId("stack.tab.top.selected");
        this.setInactiveRightColorId("stack.tab.bottom.selected");
        this.setInactiveTextColorId("stack.tab.text");
        this.borderColor = new TitleColor("stack.border", (DockTitle)this, Color.BLACK){

            protected void changed(Color color, Color color2) {
                BasicTabDockTitle.this.repaint();
            }
        };
        this.addConditionalFont("tab.focused", TitleFont.KIND_TAB_TITLE_FONT, new Condition(){

            public boolean getState() {
                return BasicTabDockTitle.this.isActive();
            }
        }, null);
        this.addConditionalFont("tab.selected", TitleFont.KIND_TAB_TITLE_FONT, new Condition(){

            public boolean getState() {
                return BasicTabDockTitle.this.selected;
            }
        }, null);
        this.addConditionalFont("tab.unselected", TitleFont.KIND_TAB_TITLE_FONT, new Condition(){

            public boolean getState() {
                return !BasicTabDockTitle.this.isActive();
            }
        }, null);
    }

    public void bind() {
        super.bind();
        DockController dockController = this.getDockable().getController();
        ColorManager colorManager = dockController.getColors();
        this.borderColor.setManager(colorManager);
    }

    public void unbind() {
        super.unbind();
        this.borderColor.setManager(null);
    }

    protected DockActionSource getActionSourceFor(Dockable dockable) {
        return new EclipseDockActionSource(this.theme, super.getActionSourceFor(dockable), dockable, true);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void changed(DockTitleEvent dockTitleEvent) {
        super.changed(dockTitleEvent);
        if (dockTitleEvent instanceof EclipseDockTitleEvent) {
            EclipseDockTitleEvent eclipseDockTitleEvent = (EclipseDockTitleEvent)dockTitleEvent;
            this.selected = eclipseDockTitleEvent.isSelected();
            this.paintIconWhenInactive = eclipseDockTitleEvent.isPaintIconWhenInactive();
            this.updateTabIcon();
        }
    }

    protected void setIcon(Icon icon) {
        if (this.selected || this.paintIconWhenInactive) {
            super.setIcon(icon);
        } else {
            super.setIcon(null);
        }
    }

    private void updateTabIcon() {
        if (this.selected || this.paintIconWhenInactive) {
            this.setIcon(this.getDockable().getTitleIcon());
        } else {
            this.setIcon(null);
        }
    }
}

